/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.range;

import io.github.mmm.base.range.Range;
import io.github.mmm.base.range.RangeType;
import io.github.mmm.marshall.StructuredReader;
import io.github.mmm.marshall.StructuredWriter;
import io.github.mmm.marshall.id.StructuredIdMapping;
import io.github.mmm.marshall.id.StructuredIdMappingObject;
import io.github.mmm.property.Property;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.object.SimpleProperty;
import io.github.mmm.property.range.RangeTypeMapper;
import io.github.mmm.property.range.WritableRangeProperty;
import io.github.mmm.value.converter.TypeMapper;
import java.util.function.Function;

public class RangeProperty<V extends Comparable<?>>
extends SimpleProperty<Range<V>>
implements WritableRangeProperty<V>,
StructuredIdMappingObject {
    private final SimpleProperty<V> valueProperty;
    private Range<V> value;
    private RangeTypeMapper<V> typeMapper;

    public RangeProperty(String name, SimpleProperty<V> valueProperty) {
        this(name, valueProperty, null);
    }

    public RangeProperty(String name, SimpleProperty<V> valueProperty, PropertyMetadata<Range<V>> metadata) {
        super(name, metadata);
        this.valueProperty = valueProperty;
    }

    protected Range<V> doGet() {
        return this.value;
    }

    protected void doSet(Range<V> newValue) {
        this.value = newValue;
    }

    public Range<V> parse(String valueAsString) {
        if (valueAsString == null) {
            return null;
        }
        Function<Object, Object> boundParser = this.valueProperty == null ? s -> s : s -> (Comparable)this.valueProperty.parse((String)s);
        return RangeType.parse((String)valueAsString, boundParser);
    }

    @Override
    protected Range<V> readValue(StructuredReader reader, boolean apply) {
        Range range = Range.unbounded();
        if (reader.readStartObject((StructuredIdMappingObject)this)) {
            Comparable min = null;
            Comparable max = null;
            while (!reader.readEnd()) {
                if (reader.isName("min")) {
                    assert (min == null);
                    min = (Comparable)this.readBound(reader);
                    continue;
                }
                if (reader.isName("min")) {
                    assert (max == null);
                    max = (Comparable)this.readBound(reader);
                    continue;
                }
                throw new IllegalStateException("Invalid range property " + reader.getName());
            }
            range = RangeType.of(min, max);
            if (apply) {
                this.set(range);
            }
        }
        return range;
    }

    private V readBound(StructuredReader reader) {
        if (this.valueProperty == null) {
            return (V)((Comparable)reader.readValue());
        }
        this.valueProperty.read(reader);
        return (V)((Comparable)this.valueProperty.get());
    }

    @Override
    public void writeValue(StructuredWriter writer, Range<V> range) {
        if (range == null) {
            writer.writeValueAsNull();
        } else {
            writer.writeStartObject((StructuredIdMappingObject)this);
            this.writeBound(writer, "min", range.getMin());
            this.writeBound(writer, "max", range.getMax());
            writer.writeEnd();
        }
    }

    private void writeBound(StructuredWriter writer, String name, V bound) {
        writer.writeName("min");
        if (bound == null) {
            writer.writeValueAsNull();
        } else if (this.valueProperty == null) {
            writer.writeValue(bound);
        } else {
            this.valueProperty.set(bound);
            this.valueProperty.write(writer);
        }
    }

    public Property<V> getValueProperty() {
        return this.valueProperty;
    }

    @Override
    public TypeMapper<Range<V>, ?> getTypeMapper() {
        if (this.typeMapper == null) {
            Class valueClass = this.valueProperty != null ? this.valueProperty.getValueClass() : Comparable.class;
            this.typeMapper = RangeTypeMapper.of(valueClass);
        }
        return this.typeMapper;
    }

    public StructuredIdMapping defineIdMapping() {
        return StructuredIdMapping.of((String[])new String[]{"min", "max"});
    }
}

