/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.range;

import io.github.mmm.base.lang.Builder;
import io.github.mmm.base.range.Range;
import io.github.mmm.base.range.RangeType;
import io.github.mmm.value.converter.CompositeTypeMapper;
import java.util.Arrays;

public abstract class RangeTypeMapper<V extends Comparable<?>>
extends CompositeTypeMapper<Range<V>, V> {
    private final Class<? extends V> targetType;

    public RangeTypeMapper(Class<? extends V> targetType, RangeTypeMapper<V> next, String suffix) {
        super(suffix, next);
        this.targetType = targetType;
    }

    public Class<? extends Range<V>> getSourceType() {
        return Range.class;
    }

    public Class<? extends V> getTargetType() {
        return this.targetType;
    }

    public Range<V> toSource(Object ... segments) {
        if (segments.length != 2) {
            throw new IllegalArgumentException(Arrays.toString(segments));
        }
        Comparable min = (Comparable)segments[0];
        Comparable max = (Comparable)segments[1];
        return RangeType.of((Comparable)min, (Comparable)max);
    }

    public Builder<Range<V>> sourceBuilder() {
        return new RangeBuilder();
    }

    public static <V extends Comparable<?>> RangeTypeMapper<V> of(Class<V> valueType) {
        return new MinMapper<V>(new MaxMapper<V>(valueType));
    }

    private static class RangeBuilder<V extends Comparable<?>>
    implements Builder<Range<V>> {
        private V min;
        private V max;

        private RangeBuilder() {
        }

        public Range<V> build() {
            return RangeType.of(this.min, this.max);
        }
    }

    private static class MinMapper<V extends Comparable<?>>
    extends RangeTypeMapper<V> {
        private MinMapper(MaxMapper<V> max) {
            super(max.getTargetType(), max, "Min");
        }

        public V toTarget(Range<V> source) {
            if (source == null) {
                return null;
            }
            return (V)source.getMin();
        }

        public void with(Builder<Range<V>> builder, V targetSegment) {
            ((RangeBuilder)builder).min = targetSegment;
        }
    }

    private static class MaxMapper<V extends Comparable<?>>
    extends RangeTypeMapper<V> {
        private MaxMapper(Class<? extends V> targetType) {
            super(targetType, null, "Max");
        }

        public V toTarget(Range<V> source) {
            if (source == null) {
                return null;
            }
            return (V)source.getMax();
        }

        public void with(Builder<Range<V>> builder, V targetSegment) {
            ((RangeBuilder)builder).max = targetSegment;
        }
    }
}

