/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.string;

import io.github.mmm.base.collection.AbstractIterator;
import io.github.mmm.marshall.StructuredReader;
import io.github.mmm.marshall.StructuredWriter;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.string.StringProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;

public abstract class StringCollectionProperty
extends StringProperty
implements Iterable<String> {
    public StringCollectionProperty(String name) {
        super(name);
    }

    public StringCollectionProperty(String name, PropertyMetadata<String> metadata) {
        super(name, metadata);
    }

    protected Collection<String> getCollection() {
        return null;
    }

    protected String getSeparator() {
        return "|";
    }

    protected boolean isEncloseWithSeparator() {
        return true;
    }

    private void doSet(String oldValue, String value) {
        if (!this.isValueEqual(value, oldValue)) {
            super.setWithChange(oldValue, value);
        }
    }

    @Override
    protected void setWithChange(String oldValue, String value) {
        Collection<String> collection = this.getCollection();
        if (collection != null) {
            collection.clear();
            Consumer<String> consumer = s -> collection.add((String)s);
            if (value != null && !((String)value).isEmpty()) {
                String separator = this.getSeparator();
                boolean enclose = this.isEncloseWithSeparator();
                this.convertCsv((String)value, separator, enclose, false, null, false, consumer);
            }
        }
        if (this.isEncloseWithSeparator() && value != null && !((String)value).isEmpty()) {
            String separator = this.getSeparator();
            if (!((String)value).startsWith(separator)) {
                value = separator + (String)value;
            }
            if (!((String)value).endsWith(separator)) {
                value = (String)value + separator;
            }
        }
        super.setWithChange(oldValue, value);
    }

    public boolean contains(String element) {
        Collection<String> collection = this.getCollection();
        if (collection != null) {
            return collection.contains(element);
        }
        return this.indexOf((String)this.get(), element) >= 0;
    }

    private int indexOf(String value, String element) {
        if (value == null) {
            return -1;
        }
        String separator = this.getSeparator();
        boolean enclose = this.isEncloseWithSeparator();
        if (enclose && (value.isEmpty() || value.equals(separator))) {
            return -1;
        }
        int valueLength = value.length();
        int elementLength = element.length();
        if (enclose) {
            String wrapped = separator + element + separator;
            return value.indexOf(wrapped);
        }
        int separatorLength = separator.length();
        if (elementLength == 0) {
            if (value.startsWith(separator)) {
                return 0;
            }
            if (value.endsWith(separator)) {
                return valueLength - separatorLength;
            }
            return value.indexOf(separator + separator);
        }
        int start = 0;
        do {
            int index;
            if ((index = value.indexOf(element, start)) < 0) {
                return -1;
            }
            boolean match = true;
            int separatorIndex = index - separatorLength;
            if (index > 0) {
                boolean bl = match = separatorIndex < 0 || value.indexOf(separator, separatorIndex) == separatorIndex;
            }
            if ((start = index + elementLength) < valueLength) {
                match &= value.indexOf(separator, start) == start;
            } else {
                start = -1;
            }
            if (!match) continue;
            if (index == 0) {
                return 0;
            }
            return separatorIndex;
        } while (start > 0);
        return -1;
    }

    public boolean add(String element) {
        boolean added;
        this.requireWritable();
        if (element == null) {
            return false;
        }
        String separator = this.getSeparator();
        assert (!element.contains(separator));
        Collection<String> collection = this.getCollection();
        if (collection != null && !(added = collection.add(element))) {
            return false;
        }
        String oldValue = (String)this.get();
        Object value = oldValue == null ? (this.isEncloseWithSeparator() ? separator + element + separator : element) : (this.isEncloseWithSeparator() ? oldValue + element + separator : oldValue + separator + element);
        this.doSet(oldValue, (String)value);
        return true;
    }

    public boolean remove(String element) {
        this.requireWritable();
        if (element == null) {
            return false;
        }
        boolean removed = false;
        Collection<String> collection = this.getCollection();
        if (collection != null && !(removed = collection.remove(element))) {
            return false;
        }
        String oldValue = (String)this.get();
        int index = this.indexOf(oldValue, element);
        if (index < 0) {
            return false;
        }
        int valueLength = oldValue.length();
        int separatorLength = this.getSeparator().length();
        int end = index + separatorLength + element.length();
        Object value = index == 0 ? (end >= valueLength ? null : (this.isEncloseWithSeparator() && end + 1 == valueLength ? null : oldValue.substring(end))) : (end >= valueLength ? oldValue.substring(0, index) : oldValue.substring(0, index) + oldValue.substring(end));
        this.doSet(oldValue, (String)value);
        return true;
    }

    public void set(Collection<String> collection) {
        String value;
        this.requireWritable();
        Collection<String> values = this.getCollection();
        if (values != null) {
            values.clear();
            if (collection != null) {
                values.addAll(collection);
            }
        }
        String oldValue = (String)this.get();
        if (collection == null) {
            value = null;
        } else {
            boolean enclose = this.isEncloseWithSeparator();
            if (collection.isEmpty()) {
                value = enclose ? "" : null;
            } else {
                String separator = this.getSeparator();
                StringBuilder sb = new StringBuilder(collection.size() * (6 + separator.length()));
                String sep = "";
                if (enclose) {
                    sep = separator;
                }
                for (String element : collection) {
                    sb.append(sep);
                    sep = separator;
                    sb.append(element);
                }
                if (enclose) {
                    sb.append(separator);
                }
                value = sb.toString();
            }
        }
        this.doSet(oldValue, value);
    }

    public String getCsv(String separator, boolean enclose) {
        String value = (String)this.get();
        String defaultSeparator = this.getSeparator();
        boolean defaultEnclose = this.isEncloseWithSeparator();
        String result = this.convertCsv(value, defaultSeparator, defaultEnclose, false, separator, enclose, null);
        return result;
    }

    public void setCsv(String csv, String separator, boolean enclose) {
        this.setCsv(csv, separator, enclose, false);
    }

    public void setCsv(String csv, String separator, boolean enclose, boolean trim) {
        this.requireWritable();
        Collection<String> collection = this.getCollection();
        Consumer<String> consumer = null;
        if (collection != null) {
            collection.clear();
            consumer = s -> collection.add((String)s);
        }
        String oldValue = (String)this.get();
        String defaultSeparator = this.getSeparator();
        boolean defaultEnclose = this.isEncloseWithSeparator();
        String value = this.convertCsv(csv, separator, enclose, trim, defaultSeparator, defaultEnclose, consumer);
        this.doSet(oldValue, value);
    }

    private String empty(boolean enclose) {
        if (enclose) {
            return "";
        }
        return null;
    }

    private String convertCsv(String csv, String csvSeparator, boolean csvEnclose, boolean trim, String targetSeparator, boolean targetEnclose, Consumer<String> consumer) {
        if (csv == null) {
            return null;
        }
        int csvLength = csv.length();
        if (csvLength == 0) {
            if (csvEnclose) {
                return this.empty(targetEnclose);
            }
            if (consumer != null) {
                consumer.accept("");
            }
            if (targetEnclose) {
                return targetSeparator + targetSeparator;
            }
            return csv;
        }
        int csvSeparatorLength = csvSeparator.length();
        int start = 0;
        if (csvEnclose) {
            assert (csv.startsWith(csvSeparator));
            start = csvSeparatorLength;
            assert (csv.endsWith(csvSeparator));
        }
        Object result = null;
        if (targetSeparator != null && (!trim || csv.indexOf(32) < 0) && targetSeparator.equals(csvSeparator)) {
            result = targetEnclose == csvEnclose ? csv : (targetEnclose ? targetSeparator + csv + targetSeparator : (csvLength > csvSeparatorLength ? csv.substring(csvSeparatorLength, csvLength - csvSeparatorLength) : ""));
        }
        StringBuilder sb = null;
        if (result == null) {
            if (targetSeparator != null) {
                sb = new StringBuilder(csvLength);
            }
        } else if (consumer == null) {
            if (csvLength <= csvSeparatorLength) {
                assert (((String)result).isEmpty());
                return null;
            }
            return result;
        }
        String sep = "";
        if (targetEnclose) {
            sep = targetSeparator;
        }
        assert (sb != null || consumer != null);
        do {
            String element;
            int index;
            if ((index = csv.indexOf(csvSeparator, start)) < 0) {
                element = csv.substring(start);
                start = csvLength;
            } else {
                element = csv.substring(start, index);
                start = index + csvSeparatorLength;
            }
            if (trim) {
                element = element.trim();
            }
            if (consumer != null) {
                consumer.accept(element);
            }
            if (sb == null) continue;
            sb.append(sep);
            sep = targetSeparator;
            sb.append(element);
        } while (start < csvLength);
        if (sb != null) {
            if (targetEnclose) {
                sb.append(targetSeparator);
            }
            result = sb.toString();
        }
        return result;
    }

    protected <C extends Collection<String>> C collect(C collection) {
        String value = (String)this.get();
        String separator = this.getSeparator();
        boolean enclose = this.isEncloseWithSeparator();
        this.convertCsv(value, separator, enclose, false, null, false, s -> collection.add(s));
        return collection;
    }

    @Override
    protected String readValue(StructuredReader reader, boolean apply) {
        if (reader.readStartArray()) {
            if (apply) {
                while (!reader.readEndArray()) {
                    String element = reader.readValueAsString();
                    this.add(element);
                }
                return (String)this.get();
            }
            StringBuilder sb = new StringBuilder();
            String separator = this.getSeparator();
            boolean encloseWithSeparator = this.isEncloseWithSeparator();
            while (!reader.readEndArray()) {
                String element = reader.readValueAsString();
                if (sb.isEmpty()) {
                    if (encloseWithSeparator) {
                        sb.append(separator);
                        sb.append(element);
                        sb.append(separator);
                        continue;
                    }
                    sb.append(element);
                    continue;
                }
                if (encloseWithSeparator) {
                    sb.append(element);
                    sb.append(separator);
                    continue;
                }
                sb.append(separator);
                sb.append(element);
            }
            return sb.toString();
        }
        return (String)super.readValue(reader, apply);
    }

    @Override
    public void writeValue(StructuredWriter writer, String value) {
        writer.writeStartArray();
        String separator = this.getSeparator();
        boolean enclose = this.isEncloseWithSeparator();
        this.convertCsv(value, separator, enclose, false, null, false, s -> writer.writeValueAsString(s));
        writer.writeEnd();
    }

    @Override
    public Iterator<String> iterator() {
        String value = (String)this.get();
        if (value == null) {
            return Collections.emptyIterator();
        }
        return new ValueIterator(value, this.getSeparator(), this.isEncloseWithSeparator());
    }

    private static class ValueIterator
    extends AbstractIterator<String> {
        private final String string;
        private final String separator;
        private final int end;
        private int index = 0;

        private ValueIterator(String string, String separator, boolean enclose) {
            this.string = string;
            this.separator = separator;
            this.end = string.length();
            if (enclose && string.startsWith(separator)) {
                this.index = separator.length();
            }
            this.findFirst();
        }

        protected String findNext() {
            if (this.index >= this.end) {
                return null;
            }
            int i = this.string.indexOf(this.separator, this.index);
            if (i < 0) {
                i = this.end;
            }
            String result = this.string.substring(this.index, i);
            this.index = i + this.separator.length();
            if (this.index >= this.end) {
                this.index = this.end;
            }
            return result;
        }
    }
}

