/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.time.month;

import io.github.mmm.marshall.StructuredReader;
import io.github.mmm.marshall.StructuredWriter;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.object.SimpleProperty;
import io.github.mmm.property.time.month.WritableMonthProperty;
import java.time.Month;

public class MonthProperty
extends SimpleProperty<Month>
implements WritableMonthProperty {
    private Month value;

    public MonthProperty(String name) {
        this(name, null, null);
    }

    public MonthProperty(String name, PropertyMetadata<Month> metadata) {
        this(name, null, metadata);
    }

    public MonthProperty(String name, Month value) {
        this(name, value, null);
    }

    public MonthProperty(String name, Month value, PropertyMetadata<Month> metadata) {
        super(name, metadata);
        this.value = value;
    }

    protected Month doGet() {
        return this.value;
    }

    protected void doSet(Month newValue) {
        this.value = newValue;
    }

    public Month getFallbackSafeValue() {
        return null;
    }

    @Override
    public void writeValue(StructuredWriter writer, Month month) {
        if (month == null) {
            writer.writeValueAsNull();
        } else {
            writer.writeValueAsInteger(month.getValue());
        }
    }

    @Override
    protected Month readValue(StructuredReader reader, boolean apply) {
        int m;
        Month month = null;
        Integer monthValue = reader.readValueAsInteger();
        if (monthValue != null && (m = monthValue.intValue()) != 0) {
            month = Month.of(m);
        }
        if (apply) {
            this.set(month);
        }
        return month;
    }
}

