/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.time.year;

import io.github.mmm.marshall.StructuredReader;
import io.github.mmm.marshall.StructuredWriter;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.object.SimpleProperty;
import io.github.mmm.property.time.year.WritableYearProperty;
import java.time.Year;

public class YearProperty
extends SimpleProperty<Year>
implements WritableYearProperty {
    private Year value;

    public YearProperty(String name) {
        this(name, null, null);
    }

    public YearProperty(String name, PropertyMetadata<Year> metadata) {
        this(name, null, metadata);
    }

    public YearProperty(String name, Year value) {
        this(name, value, null);
    }

    public YearProperty(String name, Year value, PropertyMetadata<Year> metadata) {
        super(name, metadata);
        this.value = value;
    }

    @Override
    protected Year readValue(StructuredReader reader, boolean apply) {
        int y;
        Year year = null;
        Integer yearValue = reader.readValueAsInteger();
        if (yearValue != null && (y = yearValue.intValue()) != 0) {
            year = Year.of(y);
        }
        if (apply) {
            this.set(year);
        }
        return year;
    }

    @Override
    public void writeValue(StructuredWriter writer, Year year) {
        if (year == null) {
            writer.writeValueAsNull();
        } else {
            writer.writeValueAsInteger(year.getValue());
        }
    }

    protected Year doGet() {
        return this.value;
    }

    protected void doSet(Year newValue) {
        this.value = newValue;
    }
}

