/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.scanner;

import io.github.mmm.base.filter.CharFilter;
import io.github.mmm.base.number.NumberType;
import io.github.mmm.base.text.CaseHelper;
import io.github.mmm.base.text.TextFormatMessage;
import io.github.mmm.base.text.TextFormatMessageHandler;
import io.github.mmm.base.text.TextFormatMessageType;
import io.github.mmm.scanner.CharEscapeHelper;
import io.github.mmm.scanner.CharScannerSyntax;
import io.github.mmm.scanner.CharStreamScanner;
import io.github.mmm.scanner.SimpleTextFormatMessageHandler;
import io.github.mmm.scanner.number.CharScannerNumberParser;
import io.github.mmm.scanner.number.CharScannerNumberParserLang;
import io.github.mmm.scanner.number.CharScannerNumberParserString;
import io.github.mmm.scanner.number.CharScannerRadixHandler;
import io.github.mmm.scanner.number.CharScannerRadixMode;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCharStreamScanner
implements CharStreamScanner {
    static final Logger LOG = LoggerFactory.getLogger(AbstractCharStreamScanner.class);
    private static final CharFilter FILTER_SINGLE_QUOTE = c -> c == 39;
    private final TextFormatMessageHandler messageHandler;
    protected String buffer;
    protected int offset;
    protected int limit;
    protected int line;
    protected int column;
    private StringBuilder sb;

    public AbstractCharStreamScanner(String charBuffer, TextFormatMessageHandler messageHandler) {
        this(charBuffer, messageHandler, 1, 1);
    }

    public AbstractCharStreamScanner(String buffer, TextFormatMessageHandler messageHandler, int line, int column) {
        this.messageHandler = messageHandler == null ? SimpleTextFormatMessageHandler.get() : messageHandler;
        this.buffer = buffer;
        this.offset = 0;
        this.limit = 0;
        this.line = line;
        this.column = column;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public void addMessage(TextFormatMessage message) {
        this.messageHandler.add(message);
    }

    public List<TextFormatMessage> getMessages() {
        return this.messageHandler.getMessages();
    }

    protected void reset() {
        this.offset = 0;
        this.limit = 0;
        this.line = 1;
        this.column = 1;
        if (this.sb != null) {
            this.sb.setLength(0);
        }
    }

    protected StringBuilder builder(StringBuilder builder) {
        if (builder != null) {
            return builder;
        }
        if (this.sb == null) {
            this.sb = new StringBuilder(64);
        }
        this.sb.setLength(0);
        return this.sb;
    }

    protected StringBuilder append(StringBuilder builder, int start, int end) {
        int len = end - start;
        if (len <= 0) {
            return builder;
        }
        StringBuilder b = this.builder(builder);
        b.append(this.buffer, start, end);
        return b;
    }

    protected String getAppended(StringBuilder builder, int start, int end) {
        if (end <= start) {
            return this.eot(builder, true);
        }
        if (builder == null) {
            return this.buffer.substring(start, end);
        }
        builder.append(this.buffer, start, end);
        return builder.toString();
    }

    @Override
    public boolean hasNext() {
        if (this.offset < this.limit) {
            return true;
        }
        return this.fill();
    }

    protected boolean isEos() {
        return true;
    }

    protected boolean isEob() {
        return true;
    }

    protected boolean isEot() {
        return this.offset >= this.limit;
    }

    protected boolean fill() {
        return false;
    }

    @Override
    public int next() {
        if (this.hasNext()) {
            return this.handleCodePoint(this.buffer.codePointAt(this.offset));
        }
        return 0;
    }

    protected int handleCodePoint(int codePoint) {
        if (codePoint == 10) {
            ++this.line;
            this.column = 1;
        } else {
            ++this.column;
        }
        this.offset = codePoint >= 65536 ? (this.offset += 2) : ++this.offset;
        return codePoint;
    }

    protected void setOffset(int newOffset) {
        assert (newOffset >= this.offset);
        assert (newOffset <= this.limit);
        while (this.offset < newOffset) {
            this.handleCodePoint(this.buffer.codePointAt(this.offset));
        }
    }

    @Override
    public int peek() {
        if (this.hasNext()) {
            return this.buffer.codePointAt(this.offset);
        }
        return 0;
    }

    protected String eot(StringBuilder builder, boolean acceptEot) {
        if (acceptEot) {
            if (builder == null) {
                return "";
            }
            return builder.toString();
        }
        return null;
    }

    @Override
    public String readUntil(int stop, boolean acceptEot) {
        if (!this.hasNext()) {
            return this.eot(null, acceptEot);
        }
        StringBuilder builder = null;
        do {
            int start = this.offset;
            while (this.offset < this.limit) {
                int codePoint = this.buffer.codePointAt(this.offset);
                this.handleCodePoint(codePoint);
                if (codePoint != stop) continue;
                return this.getAppended(builder, start, this.offset - 1);
            }
            builder = this.append(builder, start, this.limit);
        } while (this.fill());
        return this.eot(builder, acceptEot);
    }

    @Override
    public String readUntil(int stop, boolean acceptEot, CharScannerSyntax syntax) {
        String result = this.readUntil(c -> c == stop, acceptEot, syntax);
        this.expectOne(stop);
        return result;
    }

    @Override
    public String readUntil(CharFilter filter, boolean acceptEot, CharScannerSyntax syntax) {
        if (!this.hasNext()) {
            return this.eot(null, acceptEot);
        }
        CharScannerSyntaxState state = new CharScannerSyntaxState(syntax, filter);
        while (true) {
            if (this.offset < this.limit) {
                int codePoint = this.buffer.codePointAt(this.offset);
                state.parse(codePoint);
                if (state.done) {
                    return state.builder.toString();
                }
                this.handleCodePoint(codePoint);
                continue;
            }
            boolean eot = this.isEot();
            if (!eot || acceptEot) {
                int len = this.limit - state.start;
                if (state.quoteEscapeActive && state.activeQuoteEscape == state.activeQuoteEnd) {
                    --len;
                }
                if (len > 0) {
                    StringBuilder builder = state.activeEntityEnd == 0 ? state.builder : state.getEntityBuilder();
                    builder.append(this.buffer, state.start, len);
                }
            }
            state.start = 0;
            eot = !this.hasNext();
            if (eot) break;
        }
        return this.eot(state.builder, acceptEot);
    }

    @Override
    public String readUntil(int stop, boolean acceptEot, int escape) {
        if (!this.hasNext()) {
            this.eot(null, acceptEot);
        }
        StringBuilder builder = null;
        do {
            int start = this.offset;
            while (this.offset < this.limit) {
                int codePoint = this.buffer.codePointAt(this.offset);
                this.handleCodePoint(codePoint);
                if (codePoint == escape) {
                    builder = this.append(builder, start, this.offset - 1);
                    if (this.offset >= this.limit && !this.fill()) {
                        return this.eot(builder, acceptEot);
                    }
                    codePoint = this.buffer.codePointAt(this.offset);
                    if (escape == stop && codePoint != stop) {
                        return this.eot(builder, true);
                    }
                    builder = this.builder(builder);
                    builder.appendCodePoint(codePoint);
                    this.handleCodePoint(codePoint);
                    start = this.offset;
                    continue;
                }
                if (codePoint != stop) continue;
                return this.getAppended(builder, start, this.offset - 1);
            }
            builder = this.append(builder, start, this.limit);
        } while (this.fill());
        return this.eot(builder, acceptEot);
    }

    @Override
    public String readUntil(CharFilter filter, boolean acceptEot) {
        if (!this.hasNext()) {
            this.eot(null, acceptEot);
        }
        StringBuilder builder = null;
        do {
            int start = this.offset;
            while (this.offset < this.limit) {
                int codePoint = this.buffer.codePointAt(this.offset);
                if (filter.accept(codePoint)) {
                    return this.getAppended(builder, start, this.offset);
                }
                this.handleCodePoint(codePoint);
            }
            builder = this.append(builder, start, this.limit);
        } while (this.fill());
        return this.eot(builder, acceptEot);
    }

    @Override
    public String readUntil(CharFilter stopFilter, boolean acceptEot, String stop, boolean ignoreCase, boolean trim) {
        int stopLength = stop.length();
        if (stopLength == 0) {
            return "";
        }
        this.verifyLookahead(stopLength);
        if (!this.hasNext()) {
            return this.eot(null, acceptEot);
        }
        if (trim) {
            this.skipWhile(32);
        }
        String stopChars = ignoreCase ? CaseHelper.toLowerCase((String)stop) : stop;
        int first = stopChars.codePointAt(0);
        Appender appender = this.newAppender(trim);
        do {
            appender.start = this.offset;
            appender.trimEnd = this.offset;
            int max = this.limit;
            if (this.isEos()) {
                max -= stopLength;
            }
            while (this.offset < max) {
                boolean found;
                int codePoint = this.buffer.codePointAt(this.offset);
                if (stopFilter.accept(codePoint)) {
                    return appender.getAppended();
                }
                if ((codePoint == first || ignoreCase && Character.toLowerCase(codePoint) == first) && (found = this.expectRestWithLookahead(stopChars, ignoreCase, appender, false))) {
                    return appender.getAppended(this.offset);
                }
                if (trim && codePoint != 32) {
                    appender.foundNonSpace();
                }
                ++this.offset;
            }
            appender.append(this.offset);
        } while (this.fill());
        this.offset = this.limit;
        return appender.toString();
    }

    protected void verifyLookahead(int length) {
    }

    protected abstract boolean expectRestWithLookahead(String var1, boolean var2, Runnable var3, boolean var4);

    @Override
    public void require(String expected, boolean ignoreCase) {
        int off = this.offset;
        int lim = this.limit;
        String buf = this.buffer;
        if (!this.expectUnsafe(expected, ignoreCase)) {
            int length = expected.length();
            StringBuilder error = new StringBuilder(24 + 2 * length);
            error.append("Expecting '");
            error.append(expected);
            error.append("' but found: ");
            int len = lim - off;
            if (len > length) {
                len = length;
            }
            error.append(buf.substring(off, lim));
            len = length - len;
            if (len > 0 && buf != this.buffer) {
                if (len > this.offset) {
                    len = this.offset;
                }
                error.append(this.buffer.substring(0, len));
            }
            throw new IllegalStateException(error.toString());
        }
    }

    @Override
    public boolean expectOne(int expected, boolean warning) {
        if (this.hasNext() && this.buffer.codePointAt(this.offset) == expected) {
            this.handleCodePoint(expected);
            return true;
        }
        if (warning) {
            this.addWarning("Expected '" + expected + "'");
        }
        return false;
    }

    @Override
    public boolean expectOne(CharFilter expected) {
        if (!this.hasNext()) {
            return false;
        }
        if (expected.accept(this.buffer.codePointAt(this.offset))) {
            ++this.offset;
            return true;
        }
        return false;
    }

    @Override
    public boolean expectUnsafe(String expected, boolean ignoreCase) {
        int len = expected.length();
        for (int i = 0; i < len; ++i) {
            int exp;
            if (!this.hasNext()) {
                return false;
            }
            int codePoint = this.buffer.codePointAt(this.offset);
            if (codePoint != (exp = expected.codePointAt(i))) {
                if (!ignoreCase) {
                    return false;
                }
                if (Character.toLowerCase(codePoint) != Character.toLowerCase(exp)) {
                    return false;
                }
            }
            this.handleCodePoint(codePoint);
        }
        return true;
    }

    @Override
    public String readLine(boolean trim) {
        if (!this.hasNext()) {
            return null;
        }
        if (trim) {
            this.skipWhile(32);
        }
        Appender appender = this.newAppender(trim);
        do {
            appender.start = this.offset;
            appender.trimEnd = this.offset;
            while (this.offset < this.limit) {
                int codePoint = this.buffer.codePointAt(this.offset);
                if (codePoint == 13) {
                    int end = this.offset;
                    this.handleCodePoint(codePoint);
                    if (this.offset < this.limit) {
                        codePoint = this.buffer.codePointAt(this.offset);
                        if (codePoint == 10) {
                            this.handleCodePoint(codePoint);
                        }
                        return appender.getAppended(end);
                    }
                    appender.append(end);
                    if (this.fill() && (codePoint = this.buffer.codePointAt(this.offset)) == 10) {
                        this.handleCodePoint(codePoint);
                    }
                    return appender.toString();
                }
                if (codePoint == 10) {
                    String result = appender.getAppended();
                    this.handleCodePoint(codePoint);
                    return result;
                }
                if (codePoint != 32) {
                    appender.foundNonSpace();
                }
                this.handleCodePoint(codePoint);
            }
            appender.append(this.limit);
        } while (this.fill());
        return appender.toString();
    }

    @Override
    public String readJavaStringLiteral(TextFormatMessageType severity) {
        if (!this.hasNext()) {
            return null;
        }
        int codePoint = this.buffer.codePointAt(this.offset);
        if (codePoint != 34) {
            return null;
        }
        this.handleCodePoint(codePoint);
        StringBuilder builder = null;
        while (this.hasNext()) {
            int start = this.offset;
            while (this.offset < this.limit) {
                codePoint = this.buffer.codePointAt(this.offset);
                this.handleCodePoint(codePoint);
                if (codePoint == 34) {
                    return this.getAppended(builder, start, this.offset - 1);
                }
                if (codePoint != 92) continue;
                builder = this.append(builder, start, this.offset - 1);
                builder = this.builder(builder);
                this.parseEscapeSequence(builder, severity);
                start = this.offset;
            }
            builder = this.append(builder, start, this.offset);
        }
        String value = "";
        if (builder != null) {
            value = builder.toString();
        }
        String message = "Java string literal not terminated";
        this.addMessage(severity, message);
        return value;
    }

    @Override
    public Character readJavaCharLiteral(TextFormatMessageType severity) {
        if (this.expectOne(39)) {
            StringBuilder error = null;
            int cp = this.next();
            int next = 0;
            if (cp == 92) {
                cp = this.next();
                if (cp == 117) {
                    cp = this.parseUnicodeEscapeSequence(severity);
                    if (this.expectOne(39)) {
                        return Character.valueOf((char)cp);
                    }
                    error = this.createUnicodeLiteralError(cp);
                } else {
                    next = this.next();
                    if (next == 39) {
                        Character character = CharEscapeHelper.resolveEscape(cp);
                        if (character != null) {
                            return character;
                        }
                    } else if (CharFilter.OCTAL_DIGIT.accept(cp) && CharFilter.OCTAL_DIGIT.accept(next)) {
                        int value = (cp - 48) * 8 + (next - 48);
                        int last = this.next();
                        if (CharFilter.OCTAL_DIGIT.accept(last) && value <= 37) {
                            value = value * 8 + (last - 48);
                            last = this.next();
                        }
                        if (last == 39) {
                            return Character.valueOf((char)value);
                        }
                        error = new StringBuilder("'\\");
                        error.append(Integer.toString(value, 8));
                        error.appendCodePoint(last);
                    }
                    if (error == null) {
                        error = new StringBuilder("'\\");
                        error.appendCodePoint(cp);
                        error.appendCodePoint(next);
                    }
                }
            } else {
                if (this.expectOne(39)) {
                    return Character.valueOf((char)cp);
                }
                error = new StringBuilder("'");
                if (cp != 0) {
                    error.appendCodePoint(cp);
                }
            }
            if (next != 39) {
                String rest = this.readUntil(FILTER_SINGLE_QUOTE, true);
                error.append(rest);
                if (this.expectOne(39)) {
                    error.append('\'');
                }
            }
            String message = "Invalid Java character literal: " + error.toString();
            this.addMessage(severity, message);
            return Character.valueOf('?');
        }
        return null;
    }

    @Override
    public Number readJavaNumberLiteral() {
        CharScannerNumberParserString numberParser = new CharScannerNumberParserString((CharScannerRadixHandler)CharScannerRadixMode.ALL, true, true, "_", true);
        this.readNumber(numberParser);
        String decimal = numberParser.asString();
        if (decimal == null) {
            return null;
        }
        Number number = null;
        int codePoint = this.peek();
        if (codePoint == 108 || codePoint == 76) {
            number = this.parseLong(decimal);
        } else if (codePoint == 102 || codePoint == 70) {
            number = Float.valueOf(decimal);
        } else if (codePoint == 100 || codePoint == 68) {
            number = Double.valueOf(decimal);
        }
        if (number == null) {
            number = decimal.indexOf(46) >= 0 || decimal.indexOf(101) >= 0 ? (Number)Double.valueOf(decimal) : (Number)this.parseInteger(decimal);
        } else {
            this.next();
        }
        return number;
    }

    private Long parseLong(String number) {
        int cp;
        char sign;
        int radix = 10;
        int len = ((String)number).length();
        int i = 0;
        if ((sign = this.numberSign(cp = ((String)number).codePointAt(i++))) != '\u0000') {
            cp = ((String)number).codePointAt(i++);
        }
        if (cp == 48 && i < len) {
            cp = ((String)number).codePointAt(i);
            if (this.isRadix16(cp)) {
                radix = 16;
                ++i;
            } else if (this.isRadix2(cp)) {
                radix = 2;
                ++i;
            } else {
                assert (cp >= 48 && cp <= 55);
                radix = 8;
            }
            number = ((String)number).substring(i);
            if (sign != '\u0000') {
                number = sign + (String)number;
            }
        }
        return Long.parseLong((String)number, radix);
    }

    private Integer parseInteger(String number) {
        int cp;
        char sign;
        int radix = 10;
        int len = ((String)number).length();
        int i = 0;
        if ((sign = this.numberSign(cp = ((String)number).codePointAt(i++))) != '\u0000') {
            cp = ((String)number).codePointAt(i++);
        }
        if (cp == 48 && i < len) {
            cp = ((String)number).codePointAt(i);
            if (this.isRadix16(cp)) {
                radix = 16;
                ++i;
            } else if (this.isRadix2(cp)) {
                radix = 2;
                ++i;
            } else {
                assert (cp >= 48 && cp <= 55);
                radix = 8;
            }
            number = ((String)number).substring(i);
            if (sign != '\u0000') {
                number = sign + (String)number;
            }
        }
        return Integer.parseInt((String)number, radix);
    }

    private StringBuilder createUnicodeLiteralError(int codePoint) {
        StringBuilder error = new StringBuilder("'\\");
        error.append('u');
        Object hex = Integer.toString(codePoint, 16);
        int length = ((String)hex).length();
        if (length == 1) {
            hex = "000" + (String)hex;
        } else if (length == 2) {
            hex = "00" + (String)hex;
        } else if (length == 3) {
            hex = "0" + (String)hex;
        }
        error.append((String)hex);
        return error;
    }

    private void parseEscapeSequence(StringBuilder builder, TextFormatMessageType severity) {
        int cp = this.next();
        if (cp == 117) {
            int value = this.parseUnicodeEscapeSequence(severity);
            builder.appendCodePoint(value);
        } else if (CharFilter.OCTAL_DIGIT.accept(cp)) {
            int value = cp - 48;
            cp = this.peek();
            if (CharFilter.OCTAL_DIGIT.accept(cp)) {
                this.next();
                value = 8 * value + (cp - 48);
                if (value <= 31 && CharFilter.OCTAL_DIGIT.accept(cp = this.peek())) {
                    this.next();
                    value = 8 * value + (cp - 48);
                }
            }
            builder.appendCodePoint(value);
        } else {
            Character resolved = CharEscapeHelper.resolveEscape(cp);
            if (resolved == null) {
                StringBuilder message = new StringBuilder("Illegal escape sequence \\");
                message.appendCodePoint(cp);
                this.addMessage(severity, message.toString());
                builder.appendCodePoint(cp);
            } else {
                builder.append(resolved.charValue());
            }
        }
    }

    private int parseUnicodeEscapeSequence(TextFormatMessageType severity) {
        this.skipWhile(117);
        int value = 0;
        int radix = 16;
        for (int i = 0; i < 4; ++i) {
            int digit = this.readDigit(radix);
            if (digit < 0) {
                Object hexString;
                if (i == 0) {
                    hexString = "";
                } else {
                    hexString = Integer.toString(value, radix);
                    while (((String)hexString).length() < i) {
                        hexString = "0" + (String)hexString;
                    }
                }
                String message = "Illegal escape sequence \\u" + (String)hexString;
                this.addMessage(severity, message);
                return 63;
            }
            value = value * radix + digit;
        }
        return value;
    }

    @Override
    public String read(int count) {
        if (!this.hasNext() || count == 0) {
            return "";
        }
        StringBuilder builder = null;
        int remain = count;
        while (remain > 0) {
            int len = this.limit - this.offset;
            if (len >= remain) {
                if (builder == null) {
                    String string = this.buffer.substring(this.offset, this.offset + remain);
                    this.setOffset(this.offset + remain);
                    return string;
                }
                len = remain;
            }
            builder = this.builder(builder);
            builder.append(this.buffer, this.offset, this.offset + len);
            this.setOffset(this.offset + len);
            if ((remain -= len) <= 0 || this.fill()) continue;
            break;
        }
        return builder.toString();
    }

    @Override
    public void read(int count, StringBuilder builder) {
        if (this.hasNext() && count > 0) {
            int remain = count;
            while (remain > 0) {
                int len = this.limit - this.offset;
                if (len > remain) {
                    len = remain;
                }
                builder.append(this.buffer, this.offset, len);
                this.setOffset(this.offset + len);
                if ((remain -= len) <= 0 || this.fill()) continue;
                break;
            }
        }
    }

    @Override
    public int readDigit(int radix) {
        int codePoint;
        int value;
        int result = -1;
        if (this.hasNext() && (value = Character.digit(codePoint = this.buffer.codePointAt(this.offset), radix)) >= 0 && value < radix) {
            result = value;
            this.handleCodePoint(codePoint);
        }
        return result;
    }

    private char numberExponent(int cp, int radix) {
        if (radix == 16) {
            if (cp == 112) {
                return 'p';
            }
            if (cp == 80) {
                return 'P';
            }
        } else {
            if (cp == 101) {
                return 'e';
            }
            if (cp == 69) {
                return 'E';
            }
        }
        return '\u0000';
    }

    @Override
    public void readNumber(CharScannerNumberParser numberParser) {
        int skipCount = 1;
        int cp = this.peek();
        char sign = this.numberSign(cp);
        if (sign != '\u0000' && numberParser.sign(sign)) {
            cp = this.peek(skipCount);
            ++skipCount;
        }
        int radix = 10;
        if (cp == 48) {
            int radixChar;
            if (skipCount == 2) {
                this.next();
                --skipCount;
            }
            assert (skipCount == 1);
            int rc = radixChar = this.peek(skipCount);
            int r = 10;
            if (this.isRadix16(radixChar)) {
                r = 16;
            } else if (this.isRadix2(radixChar)) {
                r = 2;
            } else if (this.isDigit(radixChar)) {
                rc = 48;
                r = 8;
            } else {
                r = 0;
            }
            radix = numberParser.radix(r, (char)rc);
            if (radix > 0) {
                if (r == 8) {
                    this.next();
                    cp = radixChar;
                } else {
                    this.skip(2);
                    cp = this.peek();
                }
            }
            if (radix < 10) {
                radix = 10;
            }
        }
        boolean todo = true;
        while (todo) {
            boolean next = false;
            boolean peek = true;
            int digit = Character.digit(cp, radix);
            if (digit >= 0) {
                next = numberParser.digit(digit, (char)cp);
            } else if (cp == 46) {
                next = numberParser.dot();
                if (!next) {
                    todo = false;
                }
            } else {
                char e = this.numberExponent(cp, radix);
                if (e != '\u0000') {
                    cp = this.peek(skipCount);
                    char eSign = this.numberSign(cp);
                    if (eSign != '\u0000') {
                        ++skipCount;
                    }
                    if ((next = numberParser.exponent(e, eSign)) && eSign == '\u0000') {
                        peek = false;
                    }
                } else {
                    String special = numberParser.special(cp);
                    if (special != null) {
                        if (this.expect(special, false, false, skipCount - 1)) {
                            skipCount = 0;
                            numberParser.special(special);
                            next = false;
                        } else {
                            todo = false;
                        }
                    } else {
                        todo = false;
                    }
                }
            }
            if (next) {
                if (skipCount > 1) {
                    this.skip(skipCount);
                    skipCount = 1;
                } else {
                    this.next();
                }
            }
            if (!peek || !todo) continue;
            cp = this.peek();
            todo = cp != 0;
        }
    }

    private boolean isRadix2(int cp) {
        return cp == 98 || cp == 66;
    }

    private boolean isRadix16(int cp) {
        return cp == 120 || cp == 88;
    }

    private boolean isDigit(int cp) {
        return cp >= 48 && cp <= 57;
    }

    private char numberSign(int cp) {
        if (cp == 43) {
            return '+';
        }
        if (cp == 45) {
            return '-';
        }
        return '\u0000';
    }

    @Override
    public Double readDouble(CharScannerRadixHandler radixMode) {
        CharScannerNumberParserString numberParser = new CharScannerNumberParserString(radixMode, true, true, "_", true);
        this.readNumber(numberParser);
        return numberParser.asDouble();
    }

    @Override
    public Float readFloat(CharScannerRadixHandler radixMode) {
        CharScannerNumberParserString numberParser = new CharScannerNumberParserString(radixMode, true, true, "_", true);
        this.readNumber(numberParser);
        return numberParser.asFloat();
    }

    @Override
    public Long readLong(CharScannerRadixHandler radixMode) {
        CharScannerNumberParserLang numberParser = new CharScannerNumberParserLang(radixMode, NumberType.LONG);
        this.readNumber(numberParser);
        return numberParser.asLong();
    }

    @Override
    public Integer readInteger(CharScannerRadixHandler radixMode) throws NumberFormatException {
        CharScannerNumberParserLang numberParser = new CharScannerNumberParserLang(radixMode, NumberType.INTEGER);
        this.readNumber(numberParser);
        return numberParser.asInteger();
    }

    @Override
    public long readUnsignedLong(int maxDigits) throws NumberFormatException {
        if (maxDigits <= 0) {
            throw new IllegalArgumentException(Integer.toString(maxDigits));
        }
        StringBuilder builder = null;
        if (this.offset >= this.limit) {
            this.fill();
        }
        int remain = maxDigits;
        while (true) {
            int start = this.offset;
            int end = this.offset + remain;
            if (end > this.limit) {
                end = this.limit;
            }
            int codePoint = 0;
            while (this.offset < end && this.isDigit(codePoint = this.buffer.codePointAt(this.offset))) {
                ++this.offset;
            }
            int len = this.offset - start;
            if (this.offset < end || (remain -= len) == 0 || start == this.limit) {
                if (len == 0 && builder == null) {
                    throw new IllegalStateException("Invalid character for long number: " + codePoint);
                }
                String number = this.getAppended(builder, start, this.offset);
                return Long.parseLong(number);
            }
            builder = this.append(builder, start, this.offset);
            this.fill();
        }
    }

    @Override
    public int skip(int count) {
        int len;
        if (count == 0 || !this.hasNext()) {
            return 0;
        }
        int skipped = 0;
        for (int remain = count; remain > 0; remain -= len) {
            len = this.limit - this.offset;
            if (len >= remain) {
                this.setOffset(this.offset + remain);
                return count;
            }
            this.setOffset(this.limit);
            skipped += len;
            if (this.fill()) continue;
            break;
        }
        return skipped;
    }

    @Override
    public int skipNewLine() {
        int skip = 0;
        if (this.hasNext()) {
            int codePointAt = this.buffer.codePointAt(this.offset);
            if (codePointAt == 10) {
                skip = 1;
            } else if (codePointAt == 13) {
                if (this.offset + 1 < this.limit && this.buffer.codePointAt(this.offset + 1) == 10) {
                    skip = 2;
                } else if (this.peek(1) == 10) {
                    this.skip(2);
                    return 2;
                }
            }
        }
        if (skip > 0) {
            this.offset += skip;
            ++this.line;
            this.column = 1;
        }
        return skip;
    }

    @Override
    public boolean skipUntil(int stop) {
        while (this.hasNext()) {
            while (this.offset < this.limit) {
                if (this.buffer.codePointAt(this.offset++) != stop) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean skipUntil(int stop, int escape) {
        boolean escapeActive = false;
        while (this.hasNext()) {
            while (this.offset < this.limit) {
                int codePoint;
                if ((codePoint = this.buffer.codePointAt(this.offset++)) == escape) {
                    escapeActive = !escapeActive;
                    continue;
                }
                if (codePoint == stop && !escapeActive) {
                    return true;
                }
                escapeActive = false;
            }
        }
        return false;
    }

    @Override
    public int skipWhile(int c) {
        int count = 0;
        while (this.hasNext()) {
            int start = this.offset;
            while (this.offset < this.limit) {
                if (this.buffer.codePointAt(this.offset) != c) {
                    return count + (this.offset - start);
                }
                this.handleCodePoint(c);
            }
            count += this.offset - start;
        }
        return count;
    }

    @Override
    public int skipWhile(CharFilter filter, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("Max must NOT be negative: " + max);
        }
        int remain = max;
        while (this.hasNext()) {
            int start = this.offset;
            int end = start + remain;
            if (end < 0) {
                end = remain;
            }
            if (end > this.limit) {
                end = this.limit;
            }
            boolean notAccepted = false;
            while (this.offset < end) {
                int cp = this.buffer.codePointAt(this.offset);
                if (!filter.accept(cp)) {
                    notAccepted = true;
                    break;
                }
                this.handleCodePoint(cp);
            }
            int len = this.offset - start;
            if (!notAccepted && (remain -= len) != 0) continue;
            break;
        }
        return max - remain;
    }

    @Override
    public boolean skipOver(String substring, boolean ignoreCase, CharFilter stopFilter) {
        int subLength = substring.length();
        if (subLength == 0) {
            return true;
        }
        this.verifyLookahead(subLength);
        if (!this.hasNext()) {
            return false;
        }
        String subChars = ignoreCase ? CaseHelper.toLowerCase((String)substring) : substring;
        int first = subChars.codePointAt(0);
        do {
            int max = this.limit;
            if (this.isEos()) {
                max -= subLength;
            }
            while (this.offset <= max) {
                int cp = this.buffer.codePointAt(this.offset);
                if (stopFilter != null && stopFilter.accept(cp)) {
                    return false;
                }
                if (cp == first || ignoreCase && Character.toLowerCase(cp) == first) {
                    boolean found = this.expectRestWithLookahead(subChars, ignoreCase, null, true);
                    if (found) {
                        return true;
                    }
                    this.next();
                    continue;
                }
                this.handleCodePoint(cp);
            }
        } while (this.fill());
        this.offset = this.limit;
        return false;
    }

    @Override
    public String readWhile(CharFilter filter, int min, int max) {
        int len;
        if (max < 0) {
            throw new IllegalArgumentException("Max must NOT be negative: " + max);
        }
        if (max < min) {
            throw new IllegalArgumentException("Min (" + min + ") must be less or requal to max (" + max + ")");
        }
        StringBuilder builder = null;
        if (this.offset >= this.limit) {
            this.fill();
        }
        int remain = max;
        do {
            int start;
            int end;
            if ((end = (start = this.offset) + remain) < 0) {
                end = remain;
            }
            if (end > this.limit) {
                end = this.limit;
            }
            while (this.offset < end) {
                int cp = this.buffer.codePointAt(this.offset);
                if (!filter.accept(cp)) {
                    return this.requireMin(this.getAppended(builder, start, this.offset), min, filter);
                }
                this.handleCodePoint(cp);
            }
            len = this.offset - start;
            builder = this.append(builder, start, this.offset);
        } while ((remain -= len) != 0 && this.fill());
        return this.requireMin(this.eot(builder, true), min, filter);
    }

    protected void requireMin(int actual, int min, CharFilter filter) {
        if (actual < min) {
            throw new IllegalStateException("Required at least " + min + " character(s) (" + filter.getDescription() + ") but found only " + actual);
        }
    }

    private String requireMin(String result, int min, CharFilter filter) {
        this.requireMin(result.length(), min, filter);
        return result;
    }

    @Override
    public String getBufferParsed() {
        return this.buffer.substring(0, this.offset);
    }

    @Override
    public String getBufferToParse() {
        if (this.offset < this.limit) {
            return this.buffer.substring(this.offset, this.limit);
        }
        return "";
    }

    public String toString() {
        return this.getBufferParsed() + "\n$^$\n" + this.getBufferToParse();
    }

    private Appender newAppender(boolean trim) {
        if (trim) {
            return new TrimmingAppender();
        }
        return new PlainAppender();
    }

    private class CharScannerSyntaxState {
        private final CharScannerSyntax syntax;
        private final CharFilter filter;
        private final int quoteStart;
        private final int quoteEnd;
        private final int escape;
        private final int quoteEscape;
        private final boolean quoteEscapeLazy;
        private final int altQuoteStart;
        private final int altQuoteEnd;
        private final int altQuoteEscape;
        private final boolean altQuoteEscapeLazy;
        private final int entityStart;
        private final int entityEnd;
        private int start;
        private boolean escapeActive;
        private int activeQuoteEnd;
        private int activeQuoteEscape;
        private int activeQuoteLazyEnd;
        private boolean activeQuoteLazy;
        private int activeEntityEnd;
        private StringBuilder builder;
        private StringBuilder entityBuilder;
        private boolean done;
        private boolean quoteEscapeActive;

        private CharScannerSyntaxState(CharScannerSyntax syntax, CharFilter filter) {
            this.syntax = syntax;
            this.filter = filter;
            this.escape = syntax.getEscape();
            this.quoteStart = syntax.getQuoteStart();
            this.quoteEnd = syntax.getQuoteEnd();
            this.quoteEscape = syntax.getQuoteEscape();
            this.quoteEscapeLazy = syntax.isQuoteEscapeLazy();
            this.altQuoteStart = syntax.getAltQuoteStart();
            this.altQuoteEnd = syntax.getAltQuoteEnd();
            this.altQuoteEscape = syntax.getAltQuoteEscape();
            this.altQuoteEscapeLazy = syntax.isAltQuoteEscapeLazy();
            this.entityStart = syntax.getEntityStart();
            this.entityEnd = syntax.getEntityEnd();
            this.builder = AbstractCharStreamScanner.this.builder(null);
            this.start = AbstractCharStreamScanner.this.offset;
            this.escapeActive = false;
            this.activeQuoteEnd = 0;
            this.activeQuoteEscape = 0;
            this.activeQuoteLazy = false;
            this.activeQuoteLazyEnd = 0;
            this.activeEntityEnd = 0;
            this.quoteEscapeActive = false;
            this.done = false;
        }

        public StringBuilder getEntityBuilder() {
            if (this.entityBuilder == null) {
                this.entityBuilder = new StringBuilder(4);
            }
            return this.entityBuilder;
        }

        private void parse(int codePoint) {
            boolean append = false;
            if (this.escapeActive) {
                this.escapeActive = false;
            } else if (this.activeQuoteEnd != 0) {
                if (this.activeQuoteLazyEnd != 0 && codePoint == this.activeQuoteLazyEnd) {
                    this.activeQuoteEnd = 0;
                    this.builder.appendCodePoint(codePoint);
                    this.start = AbstractCharStreamScanner.this.offset + 1;
                } else if (this.quoteEscapeActive) {
                    this.quoteEscapeActive = false;
                    if (codePoint == this.activeQuoteEnd) {
                        this.builder.appendCodePoint(codePoint);
                        this.start = AbstractCharStreamScanner.this.offset + 1;
                    } else if (this.activeQuoteEscape == this.activeQuoteEnd) {
                        this.activeQuoteEnd = 0;
                        this.start = AbstractCharStreamScanner.this.offset;
                    }
                } else if (codePoint == this.activeQuoteEscape) {
                    append = true;
                    this.quoteEscapeActive = true;
                } else if (codePoint == this.activeQuoteEnd) {
                    this.activeQuoteEnd = 0;
                    append = true;
                }
                this.activeQuoteLazyEnd = 0;
            } else if (this.activeEntityEnd != 0) {
                if (codePoint == this.activeEntityEnd) {
                    String entity;
                    this.activeEntityEnd = 0;
                    int len = AbstractCharStreamScanner.this.offset - this.start;
                    if (this.entityBuilder == null) {
                        entity = AbstractCharStreamScanner.this.buffer.substring(this.start, AbstractCharStreamScanner.this.offset);
                    } else {
                        this.entityBuilder.append(AbstractCharStreamScanner.this.buffer, this.start, len);
                        entity = this.entityBuilder.toString();
                        this.entityBuilder = null;
                    }
                    this.builder.append(this.syntax.resolveEntity(entity));
                    this.start = AbstractCharStreamScanner.this.offset + 1;
                }
            } else if (this.filter.accept(codePoint)) {
                append = true;
                this.done = true;
            } else if (codePoint == this.escape) {
                append = true;
                this.escapeActive = true;
            } else if (codePoint == this.entityStart) {
                this.activeEntityEnd = this.entityEnd;
                append = true;
            } else {
                if (codePoint == this.quoteStart) {
                    this.activeQuoteEnd = this.quoteEnd;
                    this.activeQuoteEscape = this.quoteEscape;
                    this.activeQuoteLazy = this.quoteEscapeLazy;
                } else if (codePoint == this.altQuoteStart) {
                    this.activeQuoteEnd = this.altQuoteEnd;
                    this.activeQuoteEscape = this.altQuoteEscape;
                    this.activeQuoteLazy = this.altQuoteEscapeLazy;
                }
                if (this.activeQuoteEnd != 0) {
                    this.quoteEscapeActive = false;
                    append = true;
                    if (this.activeQuoteLazy && this.activeQuoteEnd == this.activeQuoteEscape && codePoint == this.activeQuoteEscape) {
                        this.activeQuoteLazyEnd = this.activeQuoteEnd;
                    }
                }
            }
            if (append) {
                if (AbstractCharStreamScanner.this.offset > this.start) {
                    this.builder.append(AbstractCharStreamScanner.this.buffer, this.start, AbstractCharStreamScanner.this.offset);
                }
                this.start = AbstractCharStreamScanner.this.offset + 1;
            }
        }
    }

    private abstract class Appender
    implements Runnable {
        protected StringBuilder builder;
        protected int start;
        protected int trimEnd;

        private Appender(AbstractCharStreamScanner abstractCharStreamScanner) {
        }

        protected abstract void append(int var1);

        protected abstract String getAppended(int var1);

        protected abstract String getAppended();

        protected void foundNonSpace() {
        }

        public String toString() {
            if (this.builder == null) {
                return "";
            }
            return this.builder.toString();
        }
    }

    private class TrimmingAppender
    extends Appender {
        private int spaceCount;

        private TrimmingAppender() {
            super(AbstractCharStreamScanner.this);
        }

        @Override
        protected void foundNonSpace() {
            this.trimEnd = AbstractCharStreamScanner.this.offset + 1;
            if (this.spaceCount > 0) {
                this.builder = AbstractCharStreamScanner.this.builder(this.builder);
                while (this.spaceCount > 0) {
                    this.builder.append(' ');
                    --this.spaceCount;
                }
            }
        }

        @Override
        protected void append(int end) {
            this.spaceCount += end - this.trimEnd;
            this.builder = AbstractCharStreamScanner.this.append(this.builder, this.start, this.trimEnd);
        }

        @Override
        protected String getAppended(int end) {
            return AbstractCharStreamScanner.this.getAppended(this.builder, this.start, this.trimEnd);
        }

        @Override
        protected String getAppended() {
            return AbstractCharStreamScanner.this.getAppended(this.builder, this.start, this.trimEnd);
        }

        @Override
        public void run() {
            this.builder = AbstractCharStreamScanner.this.append(this.builder, this.start, this.trimEnd);
        }
    }

    private class PlainAppender
    extends Appender {
        private PlainAppender() {
            super(AbstractCharStreamScanner.this);
        }

        @Override
        protected void append(int end) {
            this.builder = AbstractCharStreamScanner.this.append(this.builder, this.start, end);
        }

        @Override
        protected String getAppended(int end) {
            return AbstractCharStreamScanner.this.getAppended(this.builder, this.start, end);
        }

        @Override
        protected String getAppended() {
            return AbstractCharStreamScanner.this.getAppended(this.builder, this.start, AbstractCharStreamScanner.this.offset);
        }

        @Override
        public void run() {
            this.builder = AbstractCharStreamScanner.this.append(this.builder, this.start, AbstractCharStreamScanner.this.offset);
        }
    }
}

