/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.scanner;

import io.github.mmm.base.filter.CharFilter;
import io.github.mmm.base.text.TextFormatMessageHandler;
import io.github.mmm.scanner.AbstractCharStreamScanner;
import java.io.IOException;
import java.io.Reader;

public class CharReaderScanner
extends AbstractCharStreamScanner {
    private Reader reader;
    private final char[] charBuffer;
    private String lookaheadBuffer;
    private int lookaheadLimit;
    protected int position;

    public CharReaderScanner() {
        this((TextFormatMessageHandler)null, (Reader)null);
    }

    public CharReaderScanner(TextFormatMessageHandler messageHandler) {
        this(messageHandler, null);
    }

    public CharReaderScanner(Reader reader) {
        this(null, reader);
    }

    public CharReaderScanner(TextFormatMessageHandler messageHandler, Reader reader) {
        this(4096, messageHandler, reader);
    }

    public CharReaderScanner(int capacity) {
        this(capacity, null, null);
    }

    public CharReaderScanner(int capacity, TextFormatMessageHandler messageHandler) {
        this(capacity, messageHandler, null);
    }

    public CharReaderScanner(int capacity, Reader reader) {
        this(capacity, null, reader);
    }

    public CharReaderScanner(int capacity, TextFormatMessageHandler messageHandler, Reader reader) {
        super("", messageHandler);
        this.charBuffer = new char[capacity + 1];
        this.reader = reader;
    }

    @Override
    public int getPosition() {
        return this.position + this.offset;
    }

    @Override
    public int peek(int lookaheadOffset) {
        if (this.hasNext()) {
            int i = this.offset + lookaheadOffset;
            if (i < this.limit) {
                return this.buffer.codePointAt(i);
            }
            if (this.fillLookahead()) {
                if ((i -= this.limit) < this.lookaheadLimit) {
                    return this.lookaheadBuffer.codePointAt(i);
                }
                this.throwLookaheadError(lookaheadOffset);
            }
        }
        return 0;
    }

    @Override
    public String peekString(int count) {
        if (!this.hasNext()) {
            return "";
        }
        int rest = this.limit - this.offset;
        if (rest >= count) {
            return this.buffer.substring(this.offset, this.offset + count);
        }
        if (this.fillLookahead()) {
            int fullRest = rest + this.lookaheadLimit;
            if (count > fullRest && !this.isEos()) {
                this.throwLookaheadError(count);
            }
            StringBuilder sb = new StringBuilder(fullRest);
            sb.append(this.buffer, this.offset, rest);
            sb.append(this.lookaheadBuffer, 0, count - rest);
            return sb.toString();
        }
        return this.buffer.substring(this.offset, this.limit);
    }

    @Override
    public String peekWhile(CharFilter filter, int maxLen) {
        int i;
        if (!this.hasNext()) {
            return "";
        }
        int end = this.offset + maxLen;
        if (end > this.limit) {
            end = this.limit;
        }
        for (i = this.offset; i < end; ++i) {
            int cp = this.buffer.codePointAt(i);
            if (filter.accept(cp)) continue;
            return this.buffer.substring(this.offset, i);
        }
        if (this.fillLookahead()) {
            int cp;
            int rest = i - this.offset;
            int fullRest = rest + this.lookaheadLimit;
            if (maxLen > fullRest && !this.isEos()) {
                this.throwLookaheadError(maxLen);
            }
            end = maxLen - rest;
            for (i = 0; i < end && filter.accept(cp = this.lookaheadBuffer.codePointAt(i)); ++i) {
            }
            StringBuilder sb = new StringBuilder(rest + i);
            sb.append(this.buffer, this.offset, this.limit);
            sb.append(this.lookaheadBuffer, 0, i);
            return sb.toString();
        }
        return this.buffer.substring(this.offset, end);
    }

    @Override
    public String getBufferToParse() {
        if (this.offset < this.limit) {
            if (this.lookaheadLimit > 0) {
                int count = this.limit - this.offset;
                StringBuilder sb = new StringBuilder(this.lookaheadLimit + count);
                sb.append(this.buffer, this.offset, count);
                sb.append(this.lookaheadBuffer, 0, this.lookaheadLimit);
                return sb.toString();
            }
            return this.buffer.substring(this.offset, this.limit);
        }
        return "";
    }

    public void setReader(Reader reader) {
        this.position = 0;
        this.reset();
        this.reader = reader;
    }

    @Override
    protected boolean fill() {
        if (this.lookaheadLimit > 0) {
            this.shiftLookahead();
            return true;
        }
        if (this.reader == null) {
            this.limit = this.offset;
            return false;
        }
        this.setOffset(this.limit);
        this.position += this.limit;
        this.offset = 0;
        try {
            int next;
            this.limit = 0;
            while (this.limit == 0) {
                this.limit = this.reader.read(this.charBuffer, 0, this.charBuffer.length - 1);
            }
            if (this.limit == -1) {
                this.close();
                this.buffer = "";
                this.limit = 0;
                return false;
            }
            char last = this.charBuffer[this.limit - 1];
            if (Character.isSurrogate(last) && (next = this.reader.read()) >= 0) {
                this.charBuffer[this.limit] = (char)next;
                ++this.limit;
            }
            this.buffer = new String(this.charBuffer, 0, this.limit);
            this.limit = this.buffer.length();
            return true;
        }
        catch (IOException e) {
            throw new IllegalStateException("Read error.", e);
        }
    }

    private boolean fillLookahead() {
        if (this.lookaheadLimit > 0) {
            return true;
        }
        if (this.reader == null) {
            return false;
        }
        try {
            this.lookaheadLimit = 0;
            while (this.lookaheadLimit == 0) {
                this.lookaheadLimit = this.reader.read(this.charBuffer);
            }
            if (this.lookaheadLimit == -1) {
                this.close();
                this.lookaheadBuffer = "";
                this.lookaheadLimit = 0;
                return false;
            }
            this.lookaheadBuffer = new String(this.charBuffer, 0, this.lookaheadLimit);
            this.lookaheadLimit = this.lookaheadBuffer.length();
            return true;
        }
        catch (IOException e) {
            throw new IllegalStateException("Read error.", e);
        }
    }

    private void shiftLookahead() {
        this.position += this.limit;
        this.setOffset(this.limit);
        String tmp = this.lookaheadBuffer;
        this.lookaheadBuffer = this.buffer;
        this.buffer = tmp;
        this.offset = 0;
        this.limit = this.lookaheadLimit;
        this.lookaheadLimit = 0;
    }

    @Override
    public void close() {
        if (this.reader == null) {
            return;
        }
        try {
            this.reader.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close reader.", (Throwable)e);
        }
        this.reader = null;
    }

    @Override
    public boolean isEos() {
        return this.reader == null;
    }

    @Override
    protected boolean isEob() {
        if (this.reader != null) {
            return false;
        }
        return this.lookaheadLimit <= 0;
    }

    @Override
    public boolean isEot() {
        if (this.offset < this.limit) {
            return false;
        }
        if (this.lookaheadLimit > 0) {
            return false;
        }
        return this.reader == null;
    }

    @Override
    public boolean expect(String expected, boolean ignoreCase, boolean lookahead, int off) {
        int expectedLength = expected.length();
        if (expectedLength == 0) {
            return true;
        }
        if (!this.hasNext()) {
            return false;
        }
        int myOffset = this.offset + off;
        if (this.isEos()) {
            int rest = this.lookaheadLimit + (this.limit - myOffset);
            if (expectedLength > rest) {
                return false;
            }
        } else {
            this.verifyLookahead(expectedLength);
        }
        int myLimit = this.limit;
        String myBuffer = this.buffer;
        int expectedIndex = 0;
        while (expectedIndex < expectedLength) {
            int expCp;
            int cp;
            if ((cp = myBuffer.codePointAt(myOffset++)) != (expCp = expected.codePointAt(expectedIndex++))) {
                if (!ignoreCase) {
                    return false;
                }
                if (Character.toLowerCase(cp) != Character.toLowerCase(expCp)) {
                    return false;
                }
            }
            if (myOffset < myLimit || expectedIndex >= expectedLength) continue;
            if (myBuffer != this.buffer) {
                throw new IllegalStateException();
            }
            if (!this.fillLookahead()) {
                return false;
            }
            myBuffer = this.lookaheadBuffer;
            myOffset = 0;
            myLimit = this.lookaheadLimit;
        }
        if (!lookahead) {
            if (myBuffer == this.lookaheadBuffer) {
                this.shiftLookahead();
            }
            this.setOffset(myOffset);
        }
        return true;
    }

    @Override
    protected void verifyLookahead(int length) {
        if (length > this.charBuffer.length) {
            this.throwLookaheadError(length);
        }
    }

    private void throwLookaheadError(int length) {
        throw new IllegalArgumentException("Lookahead size of " + length + " characters exceeds the configured buffer size of " + this.charBuffer.length);
    }

    @Override
    protected boolean expectRestWithLookahead(String stopChars, boolean ignoreCase, Runnable appender, boolean skip) {
        int bufferIndex = this.offset + 1;
        int stopIndex = 1;
        int stopLength = stopChars.length();
        while (stopIndex < stopLength) {
            int stopCp;
            int cp;
            if (bufferIndex == this.limit) {
                if (!this.fillLookahead()) {
                    if (skip) {
                        this.setOffset(this.limit);
                    }
                    return false;
                }
                int lookaheadIndex = 0;
                while (stopIndex < stopLength) {
                    int stopCp2;
                    int cp2;
                    if ((cp2 = this.lookaheadBuffer.codePointAt(lookaheadIndex++)) == (stopCp2 = stopChars.codePointAt(stopIndex++)) || ignoreCase && Character.toLowerCase(cp2) == stopCp2) continue;
                    return false;
                }
                if (appender != null) {
                    appender.run();
                }
                if (skip) {
                    this.shiftLookahead();
                    this.setOffset(lookaheadIndex);
                }
                return true;
            }
            if ((cp = this.buffer.codePointAt(bufferIndex++)) == (stopCp = stopChars.codePointAt(stopIndex++)) || ignoreCase && Character.toLowerCase(cp) == stopCp) continue;
            return false;
        }
        if (skip) {
            this.setOffset(bufferIndex);
        }
        return true;
    }

    @Override
    protected void reset() {
        super.reset();
        this.lookaheadLimit = 0;
        this.position = 0;
    }
}

