/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.scanner;

import io.github.mmm.base.filter.CharFilter;
import io.github.mmm.base.text.TextFormatMessageHandler;
import io.github.mmm.scanner.AbstractCharStreamScanner;

public class CharSequenceScanner
extends AbstractCharStreamScanner {
    private String string;
    private final int initialOffset;

    public CharSequenceScanner(CharSequence charSequence) {
        this(charSequence, null);
    }

    public CharSequenceScanner(CharSequence charSequence, TextFormatMessageHandler messageHandler) {
        this(charSequence.toString(), messageHandler);
    }

    public CharSequenceScanner(String string) {
        this(string, null);
    }

    public CharSequenceScanner(String string, TextFormatMessageHandler messageHandler) {
        this(string, messageHandler, 1, 1);
    }

    public CharSequenceScanner(String string, TextFormatMessageHandler messageHandler, int line, int column) {
        this(string, 0, string.length(), messageHandler, line, column);
        this.string = string;
    }

    public CharSequenceScanner(String characters, int offset, int length, TextFormatMessageHandler messageHandler, int line, int column) {
        super(characters, messageHandler, line, column);
        if (offset < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(offset));
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(length));
        }
        if (offset > characters.length() - length) {
            throw new IndexOutOfBoundsException(Integer.toString(offset + length));
        }
        this.offset = offset;
        this.initialOffset = offset;
        this.limit = offset + length;
        this.offset = this.initialOffset;
    }

    public int charAt(int index) {
        return this.buffer.codePointAt(this.initialOffset + index);
    }

    @Override
    public int getPosition() {
        return this.offset - this.initialOffset;
    }

    public int getLength() {
        return this.limit - this.initialOffset;
    }

    public String substring(int start, int end) {
        return this.buffer.substring(this.initialOffset + start, this.initialOffset + end);
    }

    public String getReplaced(String substitute, int start, int end) {
        StringBuilder builder = this.builder(null);
        builder.append(this.buffer, this.initialOffset, start);
        builder.append(substitute);
        builder.append(this.buffer, this.initialOffset + end, this.limit);
        return builder.toString();
    }

    public void appendSubstring(StringBuilder appendable, int start, int end) {
        appendable.append(this.buffer, this.initialOffset + start, end - start);
    }

    public int getCurrentIndex() {
        return this.offset - this.initialOffset;
    }

    public void setCurrentIndex(int index) {
        if (index < 0 || index > this.getLength()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        this.offset = this.initialOffset + index;
    }

    @Override
    public boolean hasNext() {
        return this.offset < this.limit;
    }

    @Override
    public int next() {
        if (this.offset < this.limit) {
            return this.handleCodePoint(this.buffer.codePointAt(this.offset));
        }
        return 0;
    }

    @Override
    public int peek() {
        if (this.offset < this.limit) {
            return this.buffer.codePointAt(this.offset);
        }
        return 0;
    }

    @Override
    public int peek(int lookaheadOffset) {
        int i = this.offset + lookaheadOffset;
        if (i < this.limit && i >= this.initialOffset && i < this.limit) {
            return this.buffer.codePointAt(i);
        }
        return 0;
    }

    @Override
    public String peekString(int count) {
        int end = this.offset + count;
        if (end > this.limit) {
            end = this.limit;
        }
        return this.buffer.substring(this.offset, end);
    }

    @Override
    public String peekWhile(CharFilter filter, int maxLen) {
        int cp;
        int i;
        if (maxLen < 0) {
            throw new IllegalArgumentException("Max must NOT be negative: " + maxLen);
        }
        int end = this.offset + maxLen;
        if (end > this.limit) {
            end = this.limit;
        }
        for (i = this.offset; i < end && filter.accept(cp = this.buffer.codePointAt(i)); ++i) {
        }
        if (i == this.offset) {
            return "";
        }
        return this.buffer.substring(this.offset, i);
    }

    @Override
    public String readUntil(CharFilter filter, boolean acceptEot) {
        int start = this.offset;
        while (this.offset < this.limit) {
            int cp = this.buffer.codePointAt(this.offset);
            if (filter.accept(cp)) {
                return this.buffer.substring(start, this.offset);
            }
            this.handleCodePoint(cp);
        }
        if (acceptEot) {
            if (this.offset > start) {
                return this.buffer.substring(start, this.offset);
            }
            return "";
        }
        return null;
    }

    @Override
    protected boolean expectRestWithLookahead(String stopChars, boolean ignoreCase, Runnable appender, boolean skip) {
        int bufferIndex = this.offset + 1;
        int stopIndex = 1;
        int stopLength = stopChars.length();
        while (stopIndex < stopLength) {
            int stopCp;
            int cp;
            if ((cp = this.buffer.codePointAt(bufferIndex++)) == (stopCp = stopChars.codePointAt(stopIndex++)) || ignoreCase && Character.toLowerCase(cp) == stopCp) continue;
            return false;
        }
        if (skip) {
            this.setOffset(bufferIndex);
        }
        return true;
    }

    @Override
    public boolean expect(String expected, boolean ignoreCase, boolean lookahead, int off) {
        int newPos = this.offset + off;
        int len = expected.length();
        if (newPos + len > this.limit) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            int expCp;
            int cp = this.buffer.codePointAt(newPos);
            if (cp != (expCp = expected.codePointAt(i))) {
                if (!ignoreCase) {
                    return false;
                }
                if (Character.toLowerCase(cp) != Character.toLowerCase(expCp)) {
                    return false;
                }
            }
            ++newPos;
        }
        if (!lookahead) {
            this.setOffset(newPos);
        }
        return true;
    }

    protected String getTail() {
        String tail = "";
        if (this.offset < this.limit) {
            tail = this.buffer.substring(this.offset, this.limit);
        }
        return tail;
    }

    protected String getTail(int maximum) {
        String tail = "";
        if (this.offset < this.limit) {
            int end = this.offset + maximum;
            if (end > this.limit) {
                end = this.limit;
            }
            tail = this.buffer.substring(this.offset, end);
        }
        return tail;
    }

    @Override
    public void require(String expected, boolean ignoreCase) {
        if (!this.expect(expected, ignoreCase)) {
            throw new IllegalStateException("Expecting '" + expected + "' but found: " + this.getTail(expected.length()));
        }
    }

    @Override
    public String readWhile(CharFilter filter, int min, int max) {
        int start = this.offset;
        int len = this.skipWhile(filter, max);
        if (len == 0) {
            return "";
        }
        return this.buffer.substring(start, start + len);
    }

    public String getOriginalString() {
        if (this.string != null) {
            this.string = this.buffer.substring(this.initialOffset);
        }
        return this.string;
    }

    @Override
    public void close() {
        this.buffer = null;
    }
}

