/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.scanner;

import io.github.mmm.base.filter.CharFilter;
import io.github.mmm.base.text.TextFormatMessageType;
import io.github.mmm.base.text.TextFormatProcessor;
import io.github.mmm.scanner.CharScannerSyntax;
import io.github.mmm.scanner.number.CharScannerNumberParser;
import io.github.mmm.scanner.number.CharScannerRadixHandler;
import io.github.mmm.scanner.number.CharScannerRadixMode;

public interface CharStreamScanner
extends TextFormatProcessor,
AutoCloseable {
    public static final int EOS = 0;

    public boolean hasNext();

    public int next();

    public int peek();

    public int peek(int var1);

    public String peekString(int var1);

    public String peekWhile(CharFilter var1, int var2);

    default public String peekUntil(CharFilter stopFilter, int maxLen) {
        return this.peekWhile(stopFilter.negate(), maxLen);
    }

    public String read(int var1);

    public void read(int var1, StringBuilder var2);

    public int getPosition();

    public String readUntil(int var1, boolean var2);

    public String readUntil(int var1, boolean var2, int var3);

    public String readUntil(int var1, boolean var2, CharScannerSyntax var3);

    public String readUntil(CharFilter var1, boolean var2);

    default public String readUntil(CharFilter filter, boolean acceptEnd, String stop) {
        return this.readUntil(filter, acceptEnd, stop, false);
    }

    default public String readUntil(CharFilter filter, boolean acceptEnd, String stop, boolean ignoreCase) {
        return this.readUntil(filter, acceptEnd, stop, ignoreCase, false);
    }

    public String readUntil(CharFilter var1, boolean var2, String var3, boolean var4, boolean var5);

    public String readUntil(CharFilter var1, boolean var2, CharScannerSyntax var3);

    default public String readUntil(CharFilter stopFilter, int min, int max) {
        return this.readWhile(stopFilter.negate(), min, max);
    }

    default public String readWhile(CharFilter filter) {
        return this.readWhile(filter, 0, Integer.MAX_VALUE);
    }

    public String readWhile(CharFilter var1, int var2, int var3);

    default public String readLine() {
        return this.readLine(false);
    }

    public String readLine(boolean var1);

    default public Boolean readBoolean() {
        return this.readBoolean(false, false);
    }

    default public Boolean readBoolean(boolean ignoreCase) {
        return this.readBoolean(ignoreCase, false);
    }

    default public Boolean readBoolean(boolean ignoreCase, boolean acceptYesNo) {
        if (this.expect("true", ignoreCase)) {
            return Boolean.TRUE;
        }
        if (this.expect("false", ignoreCase)) {
            return Boolean.FALSE;
        }
        if (!acceptYesNo) {
            return null;
        }
        if (this.expect("yes", ignoreCase)) {
            return Boolean.TRUE;
        }
        if (this.expect("no", ignoreCase)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public void readNumber(CharScannerNumberParser var1);

    default public Double readDouble() throws NumberFormatException {
        return this.readDouble(CharScannerRadixMode.ONLY_10);
    }

    public Double readDouble(CharScannerRadixHandler var1) throws NumberFormatException;

    default public Float readFloat() throws NumberFormatException {
        return this.readFloat(CharScannerRadixMode.ONLY_10);
    }

    public Float readFloat(CharScannerRadixHandler var1) throws NumberFormatException;

    default public Long readLong() throws NumberFormatException {
        return this.readLong(CharScannerRadixMode.ONLY_10);
    }

    public Long readLong(CharScannerRadixHandler var1);

    default public Integer readInteger() throws NumberFormatException {
        return this.readInteger(CharScannerRadixMode.ONLY_10);
    }

    public Integer readInteger(CharScannerRadixHandler var1) throws NumberFormatException;

    public Number readJavaNumberLiteral();

    default public int readDigit() {
        return this.readDigit(10);
    }

    public int readDigit(int var1);

    public long readUnsignedLong(int var1) throws NumberFormatException;

    default public String readJavaStringLiteral() {
        return this.readJavaStringLiteral(TextFormatMessageType.ERROR);
    }

    public String readJavaStringLiteral(TextFormatMessageType var1);

    default public Character readJavaCharLiteral() {
        return this.readJavaCharLiteral(TextFormatMessageType.ERROR);
    }

    public Character readJavaCharLiteral(TextFormatMessageType var1);

    default public boolean expect(String expected) {
        return this.expect(expected, false, false, 0);
    }

    default public boolean expect(String expected, boolean ignoreCase) {
        return this.expect(expected, ignoreCase, false, 0);
    }

    default public boolean expect(String expected, boolean ignoreCase, boolean lookahead) {
        return this.expect(expected, ignoreCase, lookahead, 0);
    }

    public boolean expect(String var1, boolean var2, boolean var3, int var4);

    default public boolean expect(String expected, boolean ignoreCase, boolean lookahead, int offset, boolean warning) {
        boolean found = this.expect(expected, ignoreCase, lookahead, offset);
        if (!found && warning) {
            this.addWarning("Expected '" + expected + "'");
        }
        return found;
    }

    default public boolean expectOne(int expected) {
        return this.expectOne(expected, false);
    }

    public boolean expectOne(int var1, boolean var2);

    default public boolean expectOne(CharFilter expected) {
        if (!this.hasNext()) {
            return false;
        }
        if (expected.accept(this.peek())) {
            this.next();
            return true;
        }
        return false;
    }

    default public boolean expectUnsafe(String expected) {
        return this.expectUnsafe(expected, false);
    }

    public boolean expectUnsafe(String var1, boolean var2);

    default public void requireOne(int expected) throws IllegalStateException {
        if (!this.hasNext()) {
            throw new IllegalStateException("Expecting '" + expected + "' but found end-of-stream.");
        }
        int next = this.peek();
        if (next != expected) {
            throw new IllegalStateException("Expecting '" + expected + "' but found: " + next);
        }
        this.next();
    }

    public void require(String var1, boolean var2);

    default public int requireOne(CharFilter filter) {
        return this.require(filter, 1, -1);
    }

    default public int requireOneOrMore(CharFilter filter) {
        return this.require(filter, 1);
    }

    default public int require(CharFilter filter, int min) {
        return this.require(filter, min, 1000);
    }

    default public int require(CharFilter filter, int min, int max) {
        int codePoint;
        int count;
        if (min < 0 || min > max && max != -1) {
            throw new IllegalArgumentException("Invalid range: " + min + "-" + max);
        }
        int num = max;
        if (max == -1) {
            num = min;
        }
        if ((count = this.skipWhile(filter, num)) < min) {
            this.invalidCharCount("at least " + min, count, filter);
        }
        if (count == max && !filter.accept(codePoint = this.peek())) {
            this.invalidCharCount("up to " + max, count, filter);
        }
        return count;
    }

    private IllegalStateException invalidCharCount(String bound, int count, CharFilter filter) {
        String description = filter.getDescription();
        Object chars = " character(s)";
        if (!"?".equals(description)) {
            chars = " character(s) matching " + description;
        }
        throw new IllegalStateException("Require " + bound + (String)chars + " but found only " + count);
    }

    public boolean skipUntil(int var1);

    public boolean skipUntil(int var1, int var2);

    public int skip(int var1);

    public int skipNewLine();

    default public boolean skipOver(String substring) {
        return this.skipOver(substring, false);
    }

    default public boolean skipOver(String substring, boolean ignoreCase) {
        return this.skipOver(substring, ignoreCase, null);
    }

    public boolean skipOver(String var1, boolean var2, CharFilter var3);

    public int skipWhile(int var1);

    default public int skipWhile(CharFilter filter) {
        return this.skipWhile(filter, Integer.MAX_VALUE);
    }

    public int skipWhile(CharFilter var1, int var2);

    default public int skipWhileAndPeek(CharFilter filter) {
        return this.skipWhileAndPeek(filter, Integer.MAX_VALUE);
    }

    default public int skipWhileAndPeek(CharFilter filter, int max) {
        this.skipWhile(filter, max);
        return this.peek();
    }

    public String getBufferParsed();

    public String getBufferToParse();

    @Override
    public void close();
}

