/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.scanner;

import io.github.mmm.base.text.AbstractTextFormatMessageHandler;
import io.github.mmm.base.text.TextFormatMessage;
import io.github.mmm.base.text.TextFormatMessageType;
import io.github.mmm.scanner.AbstractCharStreamScanner;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class SimpleTextFormatMessageHandler
extends AbstractTextFormatMessageHandler {
    public static final Function<TextFormatMessageType, Level> LOG_MAPPER_DEFAULT = new LogLevelMapper(false);
    public static final Function<TextFormatMessageType, Level> LOG_MAPPER_INFO_AS_DEBUG = new LogLevelMapper(true);
    private static final SimpleTextFormatMessageHandler INSTANCE = new SimpleTextFormatMessageHandler(false, AbstractCharStreamScanner.LOG, LOG_MAPPER_INFO_AS_DEBUG, false);
    private final Logger logger;
    private final Function<TextFormatMessageType, Level> logLevelMapper;

    public SimpleTextFormatMessageHandler(boolean throwOnError, Logger logger, Function<TextFormatMessageType, Level> logLevelMapper, boolean collectMessages) {
        super(throwOnError, collectMessages);
        this.logger = logger;
        this.logLevelMapper = logLevelMapper;
    }

    private void log(TextFormatMessage message) {
        if (this.logger == null) {
            return;
        }
        Level level = this.logLevelMapper.apply(message.getType());
        if (level != null) {
            String logMsg = "At line {} in column {}: {}";
            switch (level) {
                case INFO: {
                    this.logger.info(logMsg, new Object[]{message.getLine(), message.getColumn(), message.getText()});
                    break;
                }
                case WARN: {
                    this.logger.warn(logMsg, new Object[]{message.getLine(), message.getColumn(), message.getText()});
                    break;
                }
                case ERROR: {
                    this.logger.error(logMsg, new Object[]{message.getLine(), message.getColumn(), message.getText()});
                    break;
                }
                default: {
                    this.logger.warn(logMsg, new Object[]{message.getLine(), message.getColumn(), message.getText()});
                }
            }
        }
    }

    public TextFormatMessage handle(TextFormatMessage message) {
        this.log(message);
        return super.handle(message);
    }

    public static SimpleTextFormatMessageHandler get() {
        return INSTANCE;
    }

    public static SimpleTextFormatMessageHandler ofThrowErrors() {
        return new SimpleTextFormatMessageHandler(true, AbstractCharStreamScanner.LOG, LOG_MAPPER_INFO_AS_DEBUG, true);
    }

    public static SimpleTextFormatMessageHandler ofThrowErrorsNoLogging() {
        return new SimpleTextFormatMessageHandler(true, null, null, true);
    }

    private static final class LogLevelMapper
    implements Function<TextFormatMessageType, Level> {
        private final boolean logInfoOnDebug;

        private LogLevelMapper(boolean logInfoOnDebug) {
            this.logInfoOnDebug = logInfoOnDebug;
        }

        @Override
        public Level apply(TextFormatMessageType t) {
            switch (t) {
                case ERROR: {
                    return Level.ERROR;
                }
                case WARNING: {
                    return Level.WARN;
                }
                case INFO: {
                    if (this.logInfoOnDebug) {
                        return Level.DEBUG;
                    }
                    return Level.INFO;
                }
            }
            return null;
        }
    }
}

