/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.scanner.number;

import io.github.mmm.scanner.number.CharScannerNumberParser;
import io.github.mmm.scanner.number.CharScannerRadixHandler;

public abstract class CharScannerNumberParserBase
implements CharScannerNumberParser {
    protected static final String NAN = "NaN";
    protected static final String INFINITY = "Infinity";
    private final CharScannerRadixHandler radixMode;
    private final CharScannerNumberSpecial[] specials;
    protected StringBuilder builder;
    protected boolean error;
    protected char sign;
    protected int radix;
    protected char radixChar;
    protected int digitsTotal;
    protected int digitsLeadingZeros;
    protected int digitsTrailingZeros;
    protected int dotPosition;
    protected char exponentSymbol;
    protected char exponentSign;
    protected int exponentDigitsTotal;
    protected int exponentDigitsLeadingZeros;
    protected boolean openDelimiter;

    public CharScannerNumberParserBase(CharScannerRadixHandler radixMode, CharScannerNumberSpecial ... specials) {
        this.radixMode = radixMode;
        this.specials = specials;
        this.radix = 10;
    }

    public static CharScannerNumberSpecial[] specials(String delimiters, boolean specialNumbers) {
        int len = delimiters.length();
        if (specialNumbers) {
            len += 2;
        }
        CharScannerNumberSpecial[] result = new CharScannerNumberSpecial[len];
        int i = 0;
        if (specialNumbers) {
            result[i++] = new CharScannerNumberSpecialNonNumber(NAN);
            result[i++] = new CharScannerNumberSpecialNonNumber(INFINITY);
        }
        int pos = 0;
        while (i < len) {
            result[i++] = new CharScannerNumberSpecialDelimiter(delimiters.codePointAt(pos++));
        }
        return result;
    }

    protected final boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    protected StringBuilder builder() {
        return this.builder;
    }

    @Override
    public boolean sign(char signChar) {
        assert (this.sign == '\u0000');
        this.sign = signChar;
        if (this.builder != null) {
            this.builder.append(signChar);
        }
        return true;
    }

    @Override
    public int radix(int newRadix, char c) {
        int r = this.radixMode.radix(newRadix, c);
        if (r != 0) {
            this.radix = r;
            this.radixChar = r == 8 && this.isDigit(c) ? (char)48 : c;
            if (this.builder != null) {
                this.appendRadix();
            }
        }
        return r;
    }

    protected void appendRadix() {
        if (this.radixChar != '\u0000') {
            this.builder.append('0');
            if (this.radixChar != '0') {
                this.builder.append(this.radixChar);
            }
        }
    }

    @Override
    public boolean digit(int digit, int digitChar) {
        if (this.builder != null) {
            this.builder.appendCodePoint(digitChar);
        }
        if (this.exponentSymbol == '\u0000') {
            if (digit == 0) {
                if (this.digitsTotal == this.digitsLeadingZeros) {
                    ++this.digitsLeadingZeros;
                } else {
                    ++this.digitsTrailingZeros;
                }
            } else {
                this.resetTrailingZeros();
            }
            ++this.digitsTotal;
        } else {
            if (digit == 0 && this.exponentDigitsTotal == this.exponentDigitsLeadingZeros) {
                ++this.exponentDigitsLeadingZeros;
            }
            ++this.exponentDigitsTotal;
        }
        return true;
    }

    protected void resetTrailingZeros() {
        this.digitsTrailingZeros = 0;
    }

    protected abstract boolean isDecimal();

    @Override
    public boolean dot() {
        if (this.isDecimal()) {
            if (this.dotPosition == -1) {
                this.dotPosition = this.digitsTotal;
            } else {
                this.error = true;
                this.builder();
            }
            if (this.builder != null) {
                this.builder.append('.');
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean exponent(char e, char signChar) {
        if (this.openDelimiter) {
            this.error = true;
            this.builder().append(e);
            if (signChar != '\u0000') {
                this.builder.append(signChar);
            }
            return true;
        }
        if (this.isDecimal()) {
            assert (this.exponentSymbol == '\u0000');
            this.exponentSymbol = e;
            this.exponentSign = signChar;
            if (this.builder != null) {
                this.appendExponent(false);
            }
            return true;
        }
        return false;
    }

    protected void appendExponent(boolean lazy) {
        if (this.exponentSymbol != '\u0000') {
            this.builder.append(this.exponentSymbol);
            if (this.exponentSign == '+' || this.exponentSign == '-' && !lazy) {
                this.builder.append(this.exponentSign);
            }
        }
    }

    @Override
    public String special(int c) {
        for (CharScannerNumberSpecial special : this.specials) {
            if (!special.isSpecialStart(c)) continue;
            if (special instanceof CharScannerNumberSpecialNonNumber && this.digitsTotal > 0) {
                return null;
            }
            return special.getSpecial();
        }
        return null;
    }

    @Override
    public void special(String special) {
        if (special.length() == 1) {
            this.openDelimiter = true;
        }
        if (this.builder != null) {
            this.builder.append(special);
        }
    }

    protected final boolean isValidDelimiterPosition() {
        if (this.exponentSign != '\u0000') {
            if (this.exponentDigitsTotal == 0) {
                return false;
            }
        } else {
            if (this.digitsTotal == 0) {
                return false;
            }
            if (this.dotPosition == this.digitsTotal) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.builder.toString();
    }

    public static interface CharScannerNumberSpecial {
        public boolean isSpecialStart(int var1);

        public String getSpecial();
    }

    public static class CharScannerNumberSpecialNonNumber
    implements CharScannerNumberSpecial {
        private final String nonNumber;
        private final char first;

        public CharScannerNumberSpecialNonNumber(String nonNumber) {
            this.nonNumber = nonNumber;
            this.first = nonNumber.charAt(0);
        }

        @Override
        public boolean isSpecialStart(int c) {
            return c == this.first;
        }

        @Override
        public String getSpecial() {
            return this.nonNumber;
        }
    }

    public static class CharScannerNumberSpecialDelimiter
    implements CharScannerNumberSpecial {
        private final int delimiter;
        private final String delimiterString;

        public CharScannerNumberSpecialDelimiter(int delimiter) {
            this.delimiter = delimiter;
            this.delimiterString = Character.toString(delimiter);
        }

        @Override
        public boolean isSpecialStart(int c) {
            return c == this.delimiter;
        }

        @Override
        public String getSpecial() {
            return this.delimiterString;
        }
    }
}

