/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.scanner.number;

import io.github.mmm.base.number.NumberType;
import io.github.mmm.scanner.number.CharScannerNumberParserBase;
import io.github.mmm.scanner.number.CharScannerRadixHandler;
import java.util.Locale;

public class CharScannerNumberParserLang
extends CharScannerNumberParserBase {
    private static final int EXPONENT_BIAS = 1023;
    private static final int EXPONENT_LIMIT = 2046;
    private static final long DOUBLE_EEE_NEGATIVE = Long.MIN_VALUE;
    private static final long DOUBLE_EEE_MASK_FRACTION = 0xFFFFFFFFFFFFFL;
    private static final int DOUBLE_MIN_E = -324;
    private static final double[] POWER_10_D = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22, 1.0E23, 1.0E24, 1.0E25, 1.0E26, 1.0E27, 1.0E28, 1.0E29, 1.0E30, 1.0E31, 1.0E32, 1.0E33, 1.0E34, 1.0E35, 1.0E36, 1.0E37, 1.0E38, 1.0E39, 1.0E40, 1.0E41, 1.0E42, 1.0E43, 1.0E44, 1.0E45, 1.0E46, 1.0E47, 1.0E48, 1.0E49, 1.0E50, 1.0E51, 1.0E52, 1.0E53, 1.0E54, 1.0E55, 1.0E56, 1.0E57, 1.0E58, 1.0E59, 1.0E60, 1.0E61, 1.0E62, 1.0E63, 1.0E64, 1.0E65, 1.0E66, 1.0E67, 1.0E68, 1.0E69, 1.0E70, 1.0E71, 1.0E72, 1.0E73, 1.0E74, 1.0E75, 1.0E76, 1.0E77, 1.0E78, 1.0E79, 1.0E80, 1.0E81, 1.0E82, 1.0E83, 1.0E84, 1.0E85, 1.0E86, 1.0E87, 1.0E88, 1.0E89, 1.0E90, 1.0E91, 1.0E92, 1.0E93, 1.0E94, 1.0E95, 1.0E96, 1.0E97, 1.0E98, 1.0E99, 1.0E100, 1.0E101, 1.0E102, 1.0E103, 1.0E104, 1.0E105, 1.0E106, 1.0E107, 1.0E108, 1.0E109, 1.0E110, 1.0E111, 1.0E112, 1.0E113, 1.0E114, 1.0E115, 1.0E116, 1.0E117, 1.0E118, 1.0E119, 1.0E120, 1.0E121, 1.0E122, 1.0E123, 1.0E124, 1.0E125, 1.0E126, 1.0E127, 1.0E128, 1.0E129, 1.0E130, 1.0E131, 1.0E132, 1.0E133, 1.0E134, 1.0E135, 1.0E136, 1.0E137, 1.0E138, 1.0E139, 1.0E140, 1.0E141, 1.0E142, 1.0E143, 1.0E144, 1.0E145, 1.0E146, 1.0E147, 1.0E148, 1.0E149, 1.0E150, 1.0E151, 1.0E152, 1.0E153, 1.0E154, 1.0E155, 1.0E156, 1.0E157, 1.0E158, 1.0E159, 1.0E160, 1.0E161, 1.0E162, 1.0E163, 1.0E164, 1.0E165, 1.0E166, 1.0E167, 1.0E168, 1.0E169, 1.0E170, 1.0E171, 1.0E172, 1.0E173, 1.0E174, 1.0E175, 1.0E176, 1.0E177, 1.0E178, 1.0E179, 1.0E180, 1.0E181, 1.0E182, 1.0E183, 1.0E184, 1.0E185, 1.0E186, 1.0E187, 1.0E188, 1.0E189, 1.0E190, 1.0E191, 1.0E192, 1.0E193, 1.0E194, 1.0E195, 1.0E196, 1.0E197, 1.0E198, 1.0E199, 1.0E200, 1.0E201, 1.0E202, 1.0E203, 1.0E204, 1.0E205, 1.0E206, 1.0E207, 1.0E208, 1.0E209, 1.0E210, 1.0E211, 1.0E212, 1.0E213, 1.0E214, 1.0E215, 1.0E216, 1.0E217, 1.0E218, 1.0E219, 1.0E220, 1.0E221, 1.0E222, 1.0E223, 1.0E224, 1.0E225, 1.0E226, 1.0E227, 1.0E228, 1.0E229, 1.0E230, 1.0E231, 1.0E232, 1.0E233, 1.0E234, 1.0E235, 1.0E236, 1.0E237, 1.0E238, 1.0E239, 1.0E240, 1.0E241, 1.0E242, 1.0E243, 1.0E244, 1.0E245, 1.0E246, 1.0E247, 1.0E248, 1.0E249, 1.0E250, 1.0E251, 1.0E252, 1.0E253, 1.0E254, 1.0E255, 1.0E256, 1.0E257, 1.0E258, 1.0E259, 1.0E260, 1.0E261, 1.0E262, 1.0E263, 1.0E264, 1.0E265, 1.0E266, 1.0E267, 1.0E268, 1.0E269, 1.0E270, 1.0E271, 1.0E272, 1.0E273, 1.0E274, 1.0E275, 1.0E276, 1.0E277, 1.0E278, 1.0E279, 1.0E280, 1.0E281, 1.0E282, 1.0E283, 1.0E284, 1.0E285, 1.0E286, 1.0E287, 1.0E288, 1.0E289, 1.0E290, 1.0E291, 1.0E292, 1.0E293, 1.0E294, 1.0E295, 1.0E296, 1.0E297, 1.0E298, 1.0E299, 1.0E300, 1.0E301, 1.0E302, 1.0E303, 1.0E304, 1.0E305, 1.0E306, 1.0E307, 1.0E308};
    private static final long[] POWER_10_L = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private final NumberType<?> numberType;
    private long min;
    private long minMul;
    private long mantissa;
    private long exponent;
    private Boolean upperCase;
    private double decimal;
    private int firstNonZeroDigit;
    private int digitsOverflow;

    public CharScannerNumberParserLang(CharScannerRadixHandler radixMode, NumberType<?> numberType) {
        this(radixMode, numberType, "", CharScannerNumberParserLang.nonDecimalMax(numberType));
    }

    public CharScannerNumberParserLang(CharScannerRadixHandler radixMode, NumberType<?> numberType, String delimiters) {
        this(radixMode, numberType, delimiters, CharScannerNumberParserLang.nonDecimalMax(numberType));
    }

    public CharScannerNumberParserLang(CharScannerRadixHandler radixMode, NumberType<?> numberType, String delimiters, long maxNonDecimal) {
        super(radixMode, CharScannerNumberParserLang.specials(delimiters, numberType == null || numberType.isImpreciseDecimal()));
        this.numberType = numberType;
        this.min = -maxNonDecimal;
        this.dotPosition = -1;
    }

    private static long nonDecimalMax(NumberType<?> numberType) {
        Number maxNumber;
        long max = Long.MAX_VALUE;
        if (!numberType.isDecimal() && (maxNumber = numberType.getMax()) != null) {
            max = maxNumber.longValue();
        }
        return max;
    }

    @Override
    protected boolean isDecimal() {
        if (this.numberType == null) {
            return true;
        }
        return this.numberType.isDecimal();
    }

    @Override
    public boolean sign(char signChar) {
        if (signChar == '-') {
            if (this.min == -2147483647L) {
                this.min = Integer.MIN_VALUE;
            } else if (this.min == -9223372036854775807L) {
                this.min = Long.MIN_VALUE;
            }
        }
        return super.sign(signChar);
    }

    @Override
    public void special(String special) {
        if (special.length() > 1) {
            switch (special) {
                case "NaN": {
                    this.decimal = Double.NaN;
                    break;
                }
                case "Infinity": {
                    this.decimal = this.sign == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                }
            }
        }
        super.special(special);
    }

    @Override
    protected StringBuilder builder() {
        if (this.builder == null) {
            this.builder = new StringBuilder();
            long v = this.mantissa;
            if (this.sign == '+') {
                this.builder.append(this.sign);
            }
            if (this.sign != '-') {
                v = -v;
            }
            this.appendRadix();
            this.appendZeros(this.digitsLeadingZeros);
            String num = Long.toString(v, this.radix);
            if (Boolean.TRUE.equals(this.upperCase)) {
                num = num.toUpperCase(Locale.ROOT);
            }
            if (this.dotPosition >= 0) {
                this.builder.append(num.substring(0, this.dotPosition));
                this.builder.append('.');
                this.builder.append(num.substring(this.dotPosition));
                this.appendZeros(this.digitsTrailingZeros);
            } else {
                this.builder.append(num);
            }
            if (this.exponentSymbol != '\u0000') {
                this.appendExponent(true);
                this.appendZeros(this.exponentDigitsLeadingZeros);
                this.builder.append(Long.toString(this.exponent));
            }
        }
        return this.builder;
    }

    private void appendZeros(int count2) {
        for (int i = 0; i < count2; ++i) {
            this.builder.append('0');
        }
    }

    private void error(int c) {
        if (this.builder == null) {
            this.builder().appendCodePoint(c);
        }
        this.error = true;
    }

    @Override
    public boolean digit(int digit, int digitChar) {
        super.digit(digit, digitChar);
        if (this.error) {
            return true;
        }
        if (this.decimal != 0.0) {
            this.error = true;
            return true;
        }
        if (this.exponentSymbol == '\u0000') {
            if (this.minMul == 0L) {
                this.minMul = this.min / (long)this.radix;
            }
            this.preventCase(digit, digitChar);
            if (this.dotPosition >= 0 && this.digitsTrailingZeros > 0) {
                return true;
            }
            if (digit > 0 && this.firstNonZeroDigit == 0) {
                this.firstNonZeroDigit = digit;
            }
            if (digit >= this.radix) {
                this.error(digitChar);
                return true;
            }
            if (this.mantissa < this.minMul) {
                if (this.isDecimal()) {
                    if (this.builder == null) {
                        long m;
                        this.builder().append(digitChar);
                        this.digitsOverflow = this.digitsTotal;
                        if (2 * digit >= this.radix && (m = this.mantissa - 1L) < this.mantissa) {
                            this.mantissa = m;
                        }
                    }
                } else {
                    this.error(digitChar);
                }
                return true;
            }
            this.mantissa *= (long)this.radix;
            if (this.mantissa < this.min + (long)digit) {
                this.mantissa /= (long)this.radix;
                this.error(digitChar);
                return true;
            }
            this.mantissa -= (long)digit;
        } else if (this.exponentDigitsTotal > this.exponentDigitsLeadingZeros) {
            this.exponent = this.exponentSign == '-' ? this.exponent * 10L - (long)digit : this.exponent * 10L + (long)digit;
        }
        return true;
    }

    @Override
    protected void resetTrailingZeros() {
        if (this.digitsTrailingZeros > 0 && this.dotPosition >= 0 && !this.error) {
            if (this.radix == 10) {
                if (this.digitsTrailingZeros < POWER_10_L.length) {
                    long m = this.mantissa * POWER_10_L[this.digitsTrailingZeros];
                    if (m >= this.mantissa) {
                        this.digitsOverflow = this.digitsTotal - this.digitsTrailingZeros;
                    } else {
                        this.mantissa = m;
                    }
                } else {
                    this.digitsOverflow = this.digitsTotal - this.digitsTrailingZeros;
                }
            } else {
                int bits = this.getRadixBits();
                long l = this.mantissa < 0L ? -this.mantissa >>> -bits - 1 : this.mantissa >>> -bits - 1;
                if (l != 0L) {
                    this.digitsOverflow = this.digitsTotal - this.digitsTrailingZeros;
                } else {
                    this.mantissa <<= bits;
                }
            }
            if (this.error) {
                this.builder();
            }
        }
        super.resetTrailingZeros();
    }

    private int getRadixBits() {
        switch (this.radix) {
            case 64: {
                return 6;
            }
            case 32: {
                return 5;
            }
            case 16: {
                return 4;
            }
            case 8: {
                return 3;
            }
            case 4: {
                return 2;
            }
            case 2: {
                return 1;
            }
        }
        throw new IllegalStateException("Illegal radix: " + this.radix);
    }

    private void preventCase(int digit, int digitChar) {
        if (digit > 9 && this.builder == null) {
            boolean upper = Character.isUpperCase(digitChar);
            if (this.upperCase == null) {
                this.upperCase = upper;
            } else if (this.upperCase != upper) {
                this.builder().appendCodePoint(digitChar);
                this.upperCase = null;
            }
        }
    }

    private boolean isEmpty() {
        return !this.error && this.digitsLeadingZeros + this.digitsTotal == 0 && this.decimal == 0.0;
    }

    public Integer asInteger() {
        assert (this.numberType == NumberType.INTEGER || this.numberType == null);
        assert (this.exponent == 0L);
        assert (this.decimal == 0.0);
        if (this.isEmpty()) {
            return null;
        }
        return (int)this.getLong();
    }

    public Long asLong() {
        assert (this.numberType == NumberType.LONG || this.numberType == null);
        assert (this.exponent == 0L);
        assert (this.decimal == 0.0);
        if (this.isEmpty()) {
            return null;
        }
        return this.getLong();
    }

    private long getLong() {
        this.throwOnError();
        if (this.sign != '-') {
            return -this.mantissa;
        }
        return this.mantissa;
    }

    private void throwOnError() {
        if (this.error) {
            throw new NumberFormatException(this.getErrorMessage());
        }
    }

    private String getErrorMessage() {
        int capacity = this.builder().length() + 20;
        if (this.radix != 10) {
            capacity += 15;
        }
        StringBuilder errorMessage = new StringBuilder(capacity);
        errorMessage.append("For input string: \"");
        errorMessage.append((CharSequence)this.builder);
        errorMessage.append('\"');
        if (this.radix != 10) {
            errorMessage.append(" under radix ");
            errorMessage.append(this.radix);
        }
        return errorMessage.toString();
    }

    public Double asDouble() {
        assert (this.numberType == NumberType.DOUBLE || this.numberType == null);
        if (this.isEmpty()) {
            return null;
        }
        return this.getDouble();
    }

    private double getDouble() {
        int shift;
        if (this.decimal != 0.0) {
            return this.decimal;
        }
        long m = this.getLong();
        if (m == 0L) {
            return 0.0;
        }
        if (this.exponent == 0L && this.dotPosition < 0 && this.digitsOverflow <= 0) {
            return m;
        }
        if (this.radix == 10) {
            long ex = this.exponent;
            if (this.dotPosition >= 0) {
                if (this.digitsOverflow > 0) {
                    ex -= (long)(this.digitsOverflow - this.digitsTrailingZeros - this.dotPosition);
                    m = m < 0L ? --m : ++m;
                } else {
                    ex -= (long)(this.digitsTotal - this.digitsTrailingZeros - this.dotPosition);
                }
            } else if (this.digitsOverflow > 0) {
                ex += (long)(this.digitsTotal - this.digitsOverflow + 1);
                m = m < 0L ? --m : ++m;
            }
            int e = (int)ex;
            if ((long)e != ex) {
                if (this.exponent < 0L) {
                    return this.zero();
                }
                return this.infinity();
            }
            if (e > 0) {
                if (e < POWER_10_D.length) {
                    return (double)m * POWER_10_D[e];
                }
                return this.infinity();
            }
            if (-e < POWER_10_D.length) {
                return (double)m / POWER_10_D[-e];
            }
            if (e < -324) {
                return this.zero();
            }
            if (this.sign == '-') {
                return -2.2250738585072014E-308;
            }
            return Double.MIN_NORMAL;
        }
        int radixBits = this.getRadixBits();
        long ex = this.exponent;
        int exOffset = this.dotPosition >= 0 ? this.dotPosition - this.digitsLeadingZeros - 1 : this.digitsTotal - this.digitsLeadingZeros - 1;
        ex += (long)(radixBits * exOffset);
        if (this.firstNonZeroDigit == 1) {
            ex += 0L;
        } else if (this.firstNonZeroDigit <= 3) {
            ++ex;
        } else if (this.firstNonZeroDigit <= 7) {
            ex += 2L;
        } else if (this.firstNonZeroDigit <= 15) {
            ex += 3L;
        } else if (this.firstNonZeroDigit <= 31) {
            ex += 4L;
        } else if (this.firstNonZeroDigit <= 63) {
            ex += 5L;
        }
        long ieee754Bits = 0L;
        if (m < 0L) {
            if (m == Long.MIN_VALUE) {
                // empty if block
            }
            m = -m;
            ieee754Bits = Long.MIN_VALUE;
        }
        if ((ex += 1023L) <= 0L || ex > 2046L) {
            return this.infinity();
        }
        ieee754Bits |= ex << 52;
        int bits = Integer.numberOfLeadingZeros((int)(m >>> 32));
        if (bits == 32) {
            bits = 32 + Integer.numberOfLeadingZeros((int)m);
        }
        if ((shift = bits - 12 + 1) > 0) {
            m <<= shift;
        } else if (shift < 0) {
            if (m << -bits - 1 != 0L) {
                this.digitsOverflow = this.digitsTotal;
            }
            m >>= -shift;
        }
        if (this.digitsOverflow != 0) {
            ++m;
        }
        return Double.longBitsToDouble(ieee754Bits |= m & 0xFFFFFFFFFFFFFL);
    }

    private double zero() {
        if (this.sign == '-') {
            return -0.0;
        }
        return 0.0;
    }

    private double infinity() {
        if (this.sign == '-') {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String toString() {
        if (this.error) {
            return this.getErrorMessage();
        }
        if (this.builder != null) {
            return this.builder.toString();
        }
        if (this.dotPosition >= 0 || this.exponentSymbol != '\u0000' || this.decimal != 0.0) {
            return Double.toString(this.getDouble());
        }
        return Long.toString(this.mantissa);
    }
}

