/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.scanner.number;

import io.github.mmm.scanner.number.CharScannerNumberParserBase;
import io.github.mmm.scanner.number.CharScannerRadixHandler;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CharScannerNumberParserString
extends CharScannerNumberParserBase {
    private final boolean acceptDecimal;
    private final boolean addRadix;

    public CharScannerNumberParserString(CharScannerRadixHandler radixMode, boolean acceptDecimal, boolean addRadix) {
        this(radixMode, acceptDecimal, addRadix, "", false);
    }

    public CharScannerNumberParserString(CharScannerRadixHandler radixMode, boolean acceptDecimal, boolean addRadix, String delimiters, boolean supportSpecials) {
        super(radixMode, CharScannerNumberParserString.specials(delimiters, supportSpecials));
        this.acceptDecimal = acceptDecimal;
        this.addRadix = addRadix;
        this.builder = new StringBuilder();
    }

    @Override
    protected boolean isDecimal() {
        return this.acceptDecimal;
    }

    @Override
    protected void appendRadix() {
        if (this.addRadix) {
            super.appendRadix();
        }
    }

    private boolean isEmpty() {
        return this.builder.length() == 0;
    }

    public BigDecimal asBigDecimal() {
        if (this.isEmpty()) {
            return null;
        }
        return new BigDecimal(this.builder.toString());
    }

    public BigInteger asBigInteger() {
        if (this.isEmpty()) {
            return null;
        }
        return new BigInteger(this.builder.toString(), this.radix);
    }

    public Double asDouble() {
        if (this.isEmpty()) {
            return null;
        }
        String string = this.builder.toString();
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("For input: " + string);
        }
    }

    public Float asFloat() {
        if (this.isEmpty()) {
            return null;
        }
        return Float.valueOf(this.builder.toString());
    }

    public String asString() {
        if (this.isEmpty()) {
            return null;
        }
        return this.builder.toString();
    }
}

