/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.collection;

import io.github.mmm.base.range.Range;
import io.github.mmm.base.range.RangeType;
import io.github.mmm.validation.Validator;
import io.github.mmm.validation.collection.ValidatorCollectionElements;
import io.github.mmm.validation.collection.ValidatorCollectionSize;
import io.github.mmm.validation.main.ContainerValidatorBuilder;
import io.github.mmm.validation.main.ObjectValidatorBuilder;
import io.github.mmm.validation.main.ObjectValidatorBuilderFactory;
import java.util.Collection;
import java.util.function.BiFunction;

public abstract class AbstractCollectionValidatorBuilder<E, V extends Collection<E>, PARENT, SELF extends AbstractCollectionValidatorBuilder<E, V, PARENT, SELF>>
extends ContainerValidatorBuilder<V, PARENT, SELF> {
    private ObjectValidatorBuilder<E, ? extends SELF, ?> subBuilder;

    public AbstractCollectionValidatorBuilder(PARENT parent) {
        super(parent);
    }

    public SELF size(Range<Integer> range) {
        return (SELF)((AbstractCollectionValidatorBuilder)this.add(new ValidatorCollectionSize(range)));
    }

    public SELF size(int min, int max) {
        return this.size((Range<Integer>)RangeType.of((Comparable)Integer.valueOf(min), (Comparable)Integer.valueOf(max)));
    }

    public SELF max(int max) {
        return this.size(0, max);
    }

    @Override
    public SELF range(String min, String max) {
        if (min != null || max != null) {
            Integer iMin = null;
            if (min != null) {
                iMin = Integer.valueOf(min);
            }
            Integer iMax = null;
            if (max != null) {
                iMax = Integer.valueOf(max);
            }
            this.add(new ValidatorCollectionSize((Range<Integer>)RangeType.of((Comparable)iMin, (Comparable)iMax)));
        }
        return (SELF)((AbstractCollectionValidatorBuilder)this.self());
    }

    public <SUB extends ObjectValidatorBuilder<E, ? extends SELF, ?>> SUB with(BiFunction<ObjectValidatorBuilderFactory<SELF>, E, SUB> factory) {
        ObjectValidatorBuilder sub;
        if (this.subBuilder != null) {
            throw new IllegalStateException("subBuilder already exists!");
        }
        this.subBuilder = sub = (ObjectValidatorBuilder)factory.apply(this.getSubFactory(), null);
        return (SUB)sub;
    }

    @Override
    public Validator<? super V> build() {
        if (this.subBuilder != null) {
            this.add(new ValidatorCollectionElements<E>(this.getValidators(this.subBuilder)));
        }
        return super.build();
    }
}

