/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.collection;

import io.github.mmm.base.range.Range;
import io.github.mmm.base.range.RangeType;
import io.github.mmm.validation.Validator;
import io.github.mmm.validation.collection.ValidatorMapKeys;
import io.github.mmm.validation.collection.ValidatorMapSize;
import io.github.mmm.validation.main.ContainerValidatorBuilder;
import io.github.mmm.validation.main.ObjectValidatorBuilder;
import io.github.mmm.validation.main.ObjectValidatorBuilderFactory;
import java.util.Map;
import java.util.function.BiFunction;

public abstract class AbstractMapValidatorBuilder<K, V, M extends Map<K, V>, PARENT, SELF extends AbstractMapValidatorBuilder<K, V, M, PARENT, SELF>>
extends ContainerValidatorBuilder<M, PARENT, SELF> {
    private ObjectValidatorBuilder<K, ? extends SELF, ?> keySubBuilder;
    private ObjectValidatorBuilder<V, ? extends SELF, ?> valueSubBuilder;

    public AbstractMapValidatorBuilder(PARENT parent) {
        super(parent);
    }

    public SELF size(Range<Integer> range) {
        return (SELF)((AbstractMapValidatorBuilder)this.add(new ValidatorMapSize(range)));
    }

    public SELF size(int min, int max) {
        return this.size((Range<Integer>)RangeType.of((Comparable)Integer.valueOf(min), (Comparable)Integer.valueOf(max)));
    }

    public SELF max(int max) {
        return this.size(0, max);
    }

    public <SUB extends ObjectValidatorBuilder<K, ? extends SELF, ?>> SUB withKeys(BiFunction<ObjectValidatorBuilderFactory<SELF>, K, SUB> factory) {
        ObjectValidatorBuilder sub;
        if (this.keySubBuilder != null) {
            throw new IllegalStateException("keySubBuilder already exists!");
        }
        this.keySubBuilder = sub = (ObjectValidatorBuilder)factory.apply(this.getSubFactory(), null);
        return (SUB)sub;
    }

    public <SUB extends ObjectValidatorBuilder<V, ? extends SELF, ?>> SUB withValues(BiFunction<ObjectValidatorBuilderFactory<SELF>, V, SUB> factory) {
        ObjectValidatorBuilder sub;
        if (this.valueSubBuilder != null) {
            throw new IllegalStateException("valueSubBuilder already exists!");
        }
        this.valueSubBuilder = sub = (ObjectValidatorBuilder)factory.apply(this.getSubFactory(), null);
        return (SUB)sub;
    }

    @Override
    public Validator<? super M> build() {
        if (this.keySubBuilder != null) {
            this.add(new ValidatorMapKeys(this.getValidators(this.keySubBuilder)));
        }
        if (this.valueSubBuilder != null) {
            this.add(new ValidatorMapKeys(this.getValidators(this.valueSubBuilder)));
        }
        return super.build();
    }
}

