/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.main;

import io.github.mmm.base.compare.CompareOperator;
import io.github.mmm.base.range.Range;
import io.github.mmm.nls.NlsMessage;
import io.github.mmm.validation.AbstractValueValidator;
import io.github.mmm.validation.main.NlsBundleValidation;
import java.util.Objects;

public abstract class AbstractValidatorRange<V, R extends Comparable<?>>
extends AbstractValueValidator<V> {
    public static final String ID = "Range";
    protected final Range<R> range;

    public AbstractValidatorRange(Range<R> range) {
        this.range = range;
    }

    public String getId() {
        return ID;
    }

    public Range<R> getRange() {
        return this.range;
    }

    public R getMin() {
        return (R)this.range.getMin();
    }

    public R getMax() {
        return (R)this.range.getMax();
    }

    protected R convertValue(V value) {
        return (R)((Comparable)value);
    }

    protected NlsMessage validateNotNull(V value) {
        R convertedValue = this.convertValue(value);
        if (this.range.contains(convertedValue)) {
            return null;
        }
        Comparable min = this.range.getMin();
        Comparable max = this.range.getMax();
        Comparable bound = null;
        CompareOperator operation = null;
        if (min == null) {
            operation = CompareOperator.LESS_OR_EQUAL;
            bound = max;
        } else if (max == null) {
            operation = CompareOperator.GREATER_OR_EQUAL;
            bound = min;
        }
        if (this.isLength()) {
            if (operation == null) {
                return NlsBundleValidation.INSTANCE.errorLengthOutOfRange(convertedValue, min, max);
            }
            return NlsBundleValidation.INSTANCE.errorLengthComparison(convertedValue, operation, bound);
        }
        if (operation == null) {
            return NlsBundleValidation.INSTANCE.errorValueOutOfRange(convertedValue, min, max);
        }
        return NlsBundleValidation.INSTANCE.errorValueComparison(convertedValue, operation, bound);
    }

    protected abstract boolean isLength();

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.range);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractValidatorRange other = (AbstractValidatorRange)((Object)obj);
        return Objects.equals(this.range, other.range);
    }
}

