/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.main;

import io.github.mmm.nls.NlsBundle;
import io.github.mmm.nls.NlsMessage;
import io.github.mmm.nls.argument.NlsArguments;

public final class NlsBundleValidation
extends NlsBundle {
    public static final NlsBundleValidation INSTANCE = new NlsBundleValidation();

    private NlsBundleValidation() {
    }

    public NlsMessage errorValueFormat(Object value, Object format) {
        return this.create("errorValueFormat", "The value has to match the format '{format}'.", NlsArguments.ofFormat((Object)format));
    }

    public NlsMessage errorMandatory() {
        return this.create("errorMandatory", "The value has to be filled.");
    }

    public NlsMessage errorPasswordMismatch() {
        return this.create("errorPasswordMismatch", "The passwords have to match.");
    }

    public NlsMessage errorValueComparison(Object value, Object operation, Object value2) {
        return this.create("errorValueComparison", "The value needs to be {operation} '{value}'.", NlsArguments.of((String)"operation", (Object)operation, (String)"value", (Object)value2));
    }

    public NlsMessage errorValueNotInPast(Object value) {
        return this.create("errorValueNotInPast", "The value has to be in the past.");
    }

    public NlsMessage errorValueNotInFuture(Object value) {
        return this.create("errorValueNotInFuture", "The value has to be in the future.");
    }

    public NlsMessage errorValueNotAfter(Object value, Object min) {
        return this.create("errorValueNotAfter", "The value has to be after '{value}'.", NlsArguments.ofValue((Object)min));
    }

    public NlsMessage errorValueNotBefore(Object value, Object max) {
        return this.create("errorValueNotAfter", "The value has to be before '{value}'.", NlsArguments.ofValue((Object)max));
    }

    public NlsMessage errorValueOutOfRange(Object value, Object min, Object max) {
        return this.create("errorValueOutOfRange", "The value needs to be in the range from {min} to {max}.", NlsArguments.ofMinMax((Object)min, (Object)max));
    }

    public NlsMessage errorLengthOutOfRange(Object value, Object min, Object max) {
        return this.create("errorLengthOutOfRange", "The length needs to be in the range from {min} to {max}.", NlsArguments.ofMinMax((Object)min, (Object)max));
    }

    public NlsMessage errorLengthComparison(Object value, Object operation, Object value2) {
        return this.create("errorLengthComparison", "The length needs to be {operation} '{value}'.", NlsArguments.of((String)"operation", (Object)operation, (String)"value", (Object)value2));
    }

    public NlsMessage errorNoEmail(Object value) {
        return this.create("errorNoEmail", "The value has to be a valid email address.");
    }

    public NlsMessage errorNoPhoneNumber(Object value) {
        return this.create("errorNoPhoneNumber", "The value has to be a valid phone number.");
    }

    public NlsMessage errorNoHost(Object value) {
        return this.create("errorNoHost", "The value has to be a valid hostname or IP-address.");
    }

    public NlsMessage errorNoHostName(Object value) {
        return this.create("errorNoHostName", "The value has to be a valid hostname.");
    }

    public NlsMessage errorNoIpAddress(Object value) {
        return this.create("errorNoIpAddress", "The value has to be a valid IP-address.");
    }

    public NlsMessage errorNoUrl(Object value) {
        return this.create("errorNoUrl", "The value has to be a valid URL.");
    }
}

