/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.main;

import io.github.mmm.base.lang.Builder;
import io.github.mmm.validation.AbstractValidator;
import io.github.mmm.validation.ComposedValidator;
import io.github.mmm.validation.Validator;
import io.github.mmm.validation.ValidatorRegistry;
import io.github.mmm.validation.main.ValidatorMandatory;
import java.util.ArrayList;
import java.util.List;

public abstract class ObjectValidatorBuilder<V, PARENT, SELF extends ObjectValidatorBuilder<V, PARENT, SELF>>
implements Builder<Validator<? super V>>,
ValidatorRegistry<V, SELF> {
    private final PARENT parent;
    private final List<Validator<? super V>> validators = new ArrayList<Validator<? super V>>();

    public ObjectValidatorBuilder(PARENT parent) {
        this.parent = parent;
    }

    public SELF add(Validator<? super V> validator) {
        this.validators.add(validator);
        return this.self();
    }

    protected <T> List<Validator<? super T>> getValidators(ObjectValidatorBuilder<T, ?, ?> builder) {
        return builder.validators;
    }

    public PARENT and() {
        return this.parent;
    }

    protected SELF self() {
        return (SELF)this;
    }

    public SELF add(AbstractValidator<? super V> validator) {
        this.validators.add((Validator<V>)validator);
        return this.self();
    }

    public SELF mandatory() {
        return this.add((AbstractValidator<? super V>)ValidatorMandatory.get());
    }

    public SELF min(String min) {
        return this.range(min, null);
    }

    public SELF max(String max) {
        return this.range(null, max);
    }

    public abstract SELF range(String var1, String var2);

    public Validator<? super V> build() {
        int size = this.validators.size();
        if (size == 0) {
            return Validator.none();
        }
        if (size == 1) {
            return this.validators.get(0);
        }
        AbstractValidator[] array = this.validators.toArray(new AbstractValidator[size]);
        return new ComposedValidator((Validator[])array);
    }
}

