/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.main;

import io.github.mmm.base.compare.CompareOperator;
import io.github.mmm.nls.NlsMessage;
import io.github.mmm.validation.AbstractValueValidator;
import io.github.mmm.validation.main.NlsBundleValidation;
import java.util.Objects;
import java.util.function.Supplier;

public class ValidatorCompare<V extends Comparable<V>>
extends AbstractValueValidator<V> {
    private final CompareOperator comparator;
    private final Supplier<V> valueSource;
    private final boolean dynamic;

    public ValidatorCompare(CompareOperator comparator, Supplier<V> valueSource) {
        this.comparator = comparator;
        this.valueSource = valueSource;
        this.dynamic = true;
    }

    public ValidatorCompare(CompareOperator comparator, V value) {
        this.comparator = comparator;
        this.valueSource = () -> value;
        this.dynamic = false;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    protected NlsMessage validateNotNull(V value) {
        Comparable value2 = (Comparable)this.valueSource.get();
        if (this.comparator.evalComparable(value, value2)) {
            return null;
        }
        return NlsBundleValidation.INSTANCE.errorValueComparison(value, this.comparator, value2);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.comparator, this.valueSource);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ValidatorCompare other = (ValidatorCompare)((Object)obj);
        return Objects.equals(this.comparator, other.comparator) && Objects.equals(this.valueSource, other.valueSource);
    }
}

