/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.string;

import io.github.mmm.base.range.NumberRangeType;
import io.github.mmm.base.range.Range;
import io.github.mmm.validation.main.ObjectValidatorBuilder;
import io.github.mmm.validation.string.ValidatorCharSequnceSize;
import io.github.mmm.validation.string.ValidatorEmail;
import io.github.mmm.validation.string.ValidatorEmailSpec;
import io.github.mmm.validation.string.ValidatorHost;
import io.github.mmm.validation.string.ValidatorHostName;
import io.github.mmm.validation.string.ValidatorIpAddress;
import io.github.mmm.validation.string.ValidatorPattern;
import io.github.mmm.validation.string.ValidatorPhoneNumber;
import io.github.mmm.validation.string.ValidatorUrl;
import java.util.regex.Pattern;

public abstract class CharSequenceValidatorBuilder<V extends CharSequence, PARENT, SELF extends CharSequenceValidatorBuilder<V, PARENT, SELF>>
extends ObjectValidatorBuilder<V, PARENT, SELF> {
    public CharSequenceValidatorBuilder(PARENT parent) {
        super(parent);
    }

    public SELF pattern(String pattern) {
        return this.pattern(Pattern.compile(pattern));
    }

    public SELF pattern(Pattern pattern) {
        return (SELF)((CharSequenceValidatorBuilder)this.add(new ValidatorPattern(pattern)));
    }

    public SELF min(int min) {
        return this.range(min, null);
    }

    public SELF max(int max) {
        return this.range(null, max);
    }

    public SELF range(Integer min, Integer max) {
        if (min != null || max != null) {
            this.add(new ValidatorCharSequnceSize((Range<Integer>)new NumberRangeType((Number)min, (Number)max)));
        }
        return (SELF)((CharSequenceValidatorBuilder)this.self());
    }

    @Override
    public SELF range(String min, String max) {
        Integer iMin = null;
        if (min != null) {
            iMin = Integer.valueOf(min);
        }
        Integer iMax = null;
        if (max != null) {
            iMax = Integer.valueOf(max);
        }
        return this.range(iMin, iMax);
    }

    public SELF email() {
        return (SELF)((CharSequenceValidatorBuilder)this.add(ValidatorEmail.get()));
    }

    public SELF emailSpec() {
        return (SELF)((CharSequenceValidatorBuilder)this.add(ValidatorEmailSpec.get()));
    }

    public SELF phoneNumber() {
        return (SELF)((CharSequenceValidatorBuilder)this.add(ValidatorPhoneNumber.get()));
    }

    public SELF host() {
        return (SELF)((CharSequenceValidatorBuilder)this.add(ValidatorHost.get()));
    }

    public SELF hostname() {
        return (SELF)((CharSequenceValidatorBuilder)this.add(ValidatorHostName.get()));
    }

    public SELF ipAddress() {
        return (SELF)((CharSequenceValidatorBuilder)this.add(ValidatorIpAddress.get()));
    }

    public SELF url() {
        return (SELF)((CharSequenceValidatorBuilder)this.add(ValidatorUrl.get()));
    }
}

