/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.string;

final class IdnEncoder {
    private static final String XN_PREFIX = "xn--";
    private static final int MAX_LABEL_LENGTH = 63;
    private static final int BASE = 36;
    private static final int BASIC_LIMIT = 128;
    private int n;
    private int delta;
    private int bias;
    private StringBuilder output = new StringBuilder(63);
    private int cpCount;
    private int cpProcessed;
    private int[] cpBuffer = new int[63];
    private boolean cpFirst;

    public String encode(String input) {
        int len = input.length();
        if (len > 63) {
            return null;
        }
        this.output.setLength(0);
        this.cpCount = 0;
        this.cpProcessed = 0;
        this.cpFirst = true;
        this.delta = 0;
        this.n = 128;
        this.bias = 72;
        boolean allAscii = true;
        for (int i = 0; i < len; ++i) {
            int c = input.charAt(i);
            if (IdnEncoder.isBasic((char)c)) {
                this.output.append(IdnEncoder.toAsciiLowerCase((char)c));
                this.cpBuffer[this.cpCount] = 0;
                ++this.cpProcessed;
            } else {
                if (allAscii && input.startsWith(XN_PREFIX)) {
                    return null;
                }
                allAscii = false;
                int cp = c;
                if (IdnEncoder.isSurrogate((char)c)) {
                    char tail;
                    boolean foundSurrogatePair = false;
                    if (IdnEncoder.isLeadSurrogate((char)c) && i < len && IdnEncoder.isTailSurrogate(tail = input.charAt(i++))) {
                        cp = IdnEncoder.getRawSupplementary((char)c, tail);
                        foundSurrogatePair = true;
                    }
                    if (!foundSurrogatePair) {
                        throw new IllegalArgumentException("Invalid character 0x" + Integer.toHexString(c));
                    }
                }
                this.cpBuffer[this.cpCount] = cp;
            }
            ++this.cpCount;
        }
        if (allAscii) {
            return this.output.toString();
        }
        if (this.output.length() == 0) {
            this.output.append(XN_PREFIX);
        } else {
            this.output.insert(0, XN_PREFIX);
            this.output.append('-');
        }
        while (this.cpProcessed < this.cpCount) {
            int m = this.findNextCodePoint();
            this.delta += (m - this.n) * (this.cpProcessed + 1);
            this.n = m;
            this.encodeCodePoints();
            ++this.delta;
            ++this.n;
        }
        return this.output.toString();
    }

    private static boolean isBasic(char c) {
        return c < '\u0080';
    }

    private static char toAsciiLowerCase(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c + 32);
        }
        return c;
    }

    private static int getRawSupplementary(char lead, char trail) {
        return (lead << 10) + trail - 56613888;
    }

    private static boolean isLeadSurrogate(char c) {
        return (c & 0xFFFFFC00) == 55296;
    }

    private static boolean isTailSurrogate(char c) {
        return (c & 0xFFFFFC00) == 56320;
    }

    private static boolean isSurrogate(char c) {
        return (c & 0xFFFFF800) == 55296;
    }

    private int adaptBias() {
        if (this.cpFirst) {
            this.cpFirst = false;
            this.delta /= 700;
        } else {
            this.delta /= 2;
        }
        this.delta += this.delta / (this.cpProcessed + 1);
        int count = 0;
        while (this.delta > 455) {
            this.delta /= 35;
            count += 36;
        }
        return count + 36 * this.delta / (this.delta + 38);
    }

    private int findNextCodePoint() {
        int m = Integer.MAX_VALUE;
        for (int i = 0; i < this.cpCount; ++i) {
            int cp = this.cpBuffer[i];
            if (cp < this.n || cp >= m) continue;
            m = cp;
        }
        return m;
    }

    private void encodeCodePoints() {
        for (int i = 0; i < this.cpCount; ++i) {
            int cp = this.cpBuffer[i];
            if (cp < this.n) {
                ++this.delta;
                continue;
            }
            if (cp != this.n) continue;
            int q = this.delta;
            int k = 36;
            while (true) {
                int t;
                if ((t = k - this.bias) < 1) {
                    t = 1;
                } else if (k >= this.bias + 26) {
                    t = 26;
                }
                if (q < t) break;
                char out = IdnEncoder.digitToBasic(t + (q - t) % (36 - t));
                this.output.append(out);
                q = (q - t) / (36 - t);
            }
            char out = IdnEncoder.digitToBasic(q);
            this.output.append(out);
            this.bias = this.adaptBias();
            this.delta = 0;
            ++this.cpProcessed;
        }
    }

    private static char digitToBasic(int digit) {
        if (digit < 26) {
            return (char)(97 + digit);
        }
        return (char)(48 + (digit - 26));
    }
}

