/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.string;

final class StringHelper {
    StringHelper() {
    }

    static int indexOfUnescaped(String string, char c, int start) {
        return StringHelper.indexOfUnescaped(string, c, start, string.length());
    }

    static int indexOfUnescaped(String string, char c, int start, int limit) {
        assert (start >= 0);
        assert (limit <= string.length());
        boolean escape = false;
        for (int i = start; i < limit; ++i) {
            char current = string.charAt(i);
            if (current == '\\') {
                escape = !escape;
                continue;
            }
            if (current == c && !escape) {
                return i;
            }
            escape = false;
        }
        return -1;
    }

    static String[] splitHost(String host) {
        int length = host.length();
        int dotIndex = host.indexOf(46);
        if (dotIndex == 0 || dotIndex == length - 1) {
            return null;
        }
        if (dotIndex == -1) {
            return new String[]{host};
        }
        int segmentCount = 1;
        int i = dotIndex;
        while (i > 0) {
            ++segmentCount;
            i = host.indexOf(46, i + 1);
        }
        String[] segments = new String[segmentCount];
        int start = 0;
        segmentCount = 0;
        while (dotIndex > 0) {
            segments[segmentCount++] = host.substring(start, dotIndex).trim();
            start = dotIndex + 1;
            dotIndex = host.indexOf(46, start);
        }
        segments[segmentCount++] = host.substring(start).trim();
        assert (segmentCount == segments.length);
        return segments;
    }

    static boolean hasBrackets(String string) {
        int length = string.length();
        return length > 2 && string.charAt(0) == '[' && string.charAt(length - 1) == ']';
    }

    static String unbracket(String string) {
        if (StringHelper.hasBrackets(string)) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }
}

