/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.string;

import io.github.mmm.nls.NlsMessage;
import io.github.mmm.validation.AbstractValueValidator;
import io.github.mmm.validation.main.NlsBundleValidation;
import io.github.mmm.validation.string.StringHelper;
import io.github.mmm.validation.string.ValidatorEmailSpec;

public final class ValidatorEmail
extends AbstractValueValidator<CharSequence> {
    private static final ValidatorEmail INSTANCE = new ValidatorEmail();
    public static final String ID = "Email";

    private ValidatorEmail() {
    }

    public String getId() {
        return ID;
    }

    protected NlsMessage validateNotNull(CharSequence value) {
        if (ValidatorEmail.isValidEmail(value.toString().trim())) {
            return null;
        }
        return NlsBundleValidation.INSTANCE.errorNoEmail(value);
    }

    static boolean isValidEmail(String email) {
        String emailSpec;
        int length = email.length();
        if (length == 0) {
            return false;
        }
        char lastChar = email.charAt(length - 1);
        if (lastChar == '.') {
            return false;
        }
        String displayName = null;
        if (lastChar == '>') {
            int ltStart = 0;
            if (email.charAt(0) == '\"' && (ltStart = StringHelper.indexOfUnescaped(email, '\"', 1, length - 4)) < 0) {
                return false;
            }
            int ltIndex = email.indexOf(60, ltStart);
            if (ltIndex < 0) {
                return false;
            }
            displayName = email.substring(0, ltIndex).trim();
            emailSpec = email.substring(ltIndex + 1, length - 1);
        } else {
            emailSpec = email;
        }
        if (!ValidatorEmailSpec.isValidEmailSpec(emailSpec)) {
            return false;
        }
        return displayName == null || ValidatorEmail.isValidDisplayName(displayName);
    }

    static boolean isValidDisplayName(String displayName) {
        if (displayName.startsWith("\"")) {
            int quoteEndIndex = StringHelper.indexOfUnescaped(displayName, '\"', 1);
            if (quoteEndIndex != displayName.length() - 1) {
                return false;
            }
        } else {
            for (int i = 0; i < displayName.length(); ++i) {
                if (ValidatorEmailSpec.LOCAL_PART_FILTER.accept((int)displayName.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static ValidatorEmail get() {
        return INSTANCE;
    }
}

