/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.string;

import io.github.mmm.base.filter.CharFilter;
import io.github.mmm.base.filter.ListCharFilter;
import io.github.mmm.nls.NlsMessage;
import io.github.mmm.validation.AbstractValueValidator;
import io.github.mmm.validation.main.NlsBundleValidation;
import io.github.mmm.validation.string.StringHelper;
import io.github.mmm.validation.string.ValidatorHostName;
import io.github.mmm.validation.string.ValidatorIpAddress;

public final class ValidatorEmailSpec
extends AbstractValueValidator<CharSequence> {
    private static final ValidatorEmailSpec INSTANCE = new ValidatorEmailSpec();
    static final CharFilter SPECIAL_CHAR_FILTER = c -> c >= 128 && c <= 65535;
    static final ListCharFilter ATEXT_SEPCIAL_CHAR_FILTER = new ListCharFilter("!#$%&'*+-/=?^_`{|}~");
    static final CharFilter ATEXT_FILTER = CharFilter.LATIN_LETTER_OR_DIGIT.compose(ATEXT_SEPCIAL_CHAR_FILTER.compose(SPECIAL_CHAR_FILTER));
    static final CharFilter LOCAL_PART_FILTER = ATEXT_FILTER.compose(SPECIAL_CHAR_FILTER);
    public static final String ID = "EmailSpec";

    private ValidatorEmailSpec() {
    }

    public String getId() {
        return ID;
    }

    protected NlsMessage validateNotNull(CharSequence value) {
        if (ValidatorEmailSpec.isValidEmailSpec(value.toString().trim())) {
            return null;
        }
        return NlsBundleValidation.INSTANCE.errorNoEmail(value);
    }

    static boolean isValidEmailSpec(String emailSpec) {
        int length = emailSpec.length();
        if (length == 0) {
            return false;
        }
        int atIndex = emailSpec.lastIndexOf(64);
        if (atIndex <= 0) {
            return false;
        }
        String localPart = emailSpec.substring(0, atIndex);
        if (!ValidatorEmailSpec.isValidLocalPart(localPart)) {
            return false;
        }
        String domain = emailSpec.substring(atIndex + 1);
        return ValidatorEmailSpec.isValidDomain(domain);
    }

    static boolean isValidDomain(String domain) {
        if (StringHelper.hasBrackets(domain)) {
            return ValidatorIpAddress.isValidIpAddress(domain);
        }
        return ValidatorHostName.isValidHostName(domain);
    }

    static boolean isValidLocalPart(String localPart) {
        int length = (localPart = localPart.trim()).length();
        if (length == 0 || length > 64) {
            return false;
        }
        int lastIndex = length - 1;
        if (length > 2 && localPart.charAt(0) == '\"' && localPart.charAt(lastIndex) == '\"') {
            boolean escape = false;
            for (int i = 1; i < lastIndex; ++i) {
                char c = localPart.charAt(i);
                if (c == '\\') {
                    escape = !escape;
                    continue;
                }
                if (c != '\"' || escape) continue;
                return false;
            }
        } else {
            int dotCount = 0;
            for (int i = 0; i < length; ++i) {
                char c = localPart.charAt(i);
                if (c == '.') {
                    if (i == 0 || i == lastIndex || dotCount > 0) {
                        return false;
                    }
                    ++dotCount;
                    continue;
                }
                if (LOCAL_PART_FILTER.accept((int)c)) {
                    dotCount = 0;
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    public static ValidatorEmailSpec get() {
        return INSTANCE;
    }
}

