/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.string;

import io.github.mmm.nls.NlsMessage;
import io.github.mmm.validation.AbstractValueValidator;
import io.github.mmm.validation.main.NlsBundleValidation;
import io.github.mmm.validation.string.ValidatorHostName;
import io.github.mmm.validation.string.ValidatorIpAddress;

public final class ValidatorHost
extends AbstractValueValidator<CharSequence> {
    private static final ValidatorHost INSTANCE = new ValidatorHost();
    public static final String ID = "Host";

    private ValidatorHost() {
    }

    public String getId() {
        return ID;
    }

    protected NlsMessage validateNotNull(CharSequence value) {
        if (ValidatorHost.isValidHost(value.toString().trim())) {
            return null;
        }
        return NlsBundleValidation.INSTANCE.errorNoHost(value);
    }

    static boolean isValidHost(String value) {
        int length = value.length();
        if (length < 2 || length >= 253) {
            return false;
        }
        if (ValidatorIpAddress.isValidIpAddress(value)) {
            return true;
        }
        return ValidatorHostName.isValidHostName(value);
    }

    public static ValidatorHost get() {
        return INSTANCE;
    }
}

