/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.string;

import io.github.mmm.base.filter.CharFilter;
import io.github.mmm.base.filter.ListCharFilter;
import io.github.mmm.nls.NlsMessage;
import io.github.mmm.validation.AbstractValueValidator;
import io.github.mmm.validation.main.NlsBundleValidation;
import io.github.mmm.validation.string.IdnEncoder;
import io.github.mmm.validation.string.StringHelper;

public final class ValidatorHostName
extends AbstractValueValidator<CharSequence> {
    private static final ValidatorHostName INSTANCE = new ValidatorHostName();
    static final CharFilter EXTRA_ASCII_FILTER = new ListCharFilter("!\"$'()*,-@[\\]_`{}");
    public static final String ID = "HostName";

    private ValidatorHostName() {
    }

    public String getId() {
        return ID;
    }

    protected NlsMessage validateNotNull(CharSequence value) {
        if (ValidatorHostName.isValidHostName(value.toString().trim())) {
            return null;
        }
        return NlsBundleValidation.INSTANCE.errorNoHostName(value);
    }

    static boolean isValidHostName(String value) {
        String[] segments = StringHelper.splitHost(value);
        return ValidatorHostName.isValidHostName(segments);
    }

    static boolean isValidHostName(String[] segments) {
        if (segments == null || segments.length == 0) {
            return false;
        }
        IdnEncoder encoder = new IdnEncoder();
        int length = segments.length - 1;
        int i = 0;
        String segment = null;
        while (i < segments.length) {
            if (!ValidatorHostName.isValidSegment(segment = segments[i++])) {
                String ascii = segment.replace("\u00df", "ss");
                if (segment.equals(ascii = encoder.encode(ascii)) || !ValidatorHostName.isValidSegment(ascii)) {
                    return false;
                }
            }
            length += segment.length();
        }
        if (length < 2 || length >= 253) {
            return false;
        }
        return ValidatorHostName.isValidTld(segment);
    }

    private static boolean isValidTld(String segment) {
        char first = segment.charAt(0);
        return CharFilter.LATIN_LETTER.accept((int)first);
    }

    private static boolean isValidSegment(String segment) {
        if (segment == null) {
            return false;
        }
        int length = segment.length();
        if (length < 1 || length > 63) {
            return false;
        }
        int last = length - 1;
        for (int i = 0; i < length; ++i) {
            char c = segment.charAt(i);
            if (CharFilter.LATIN_LETTER_OR_DIGIT.accept((int)c)) continue;
            if (i == 0) {
                return false;
            }
            if (!(c == '-' ? i == last : !EXTRA_ASCII_FILTER.accept((int)c))) continue;
            return false;
        }
        return true;
    }

    public static ValidatorHostName get() {
        return INSTANCE;
    }
}

