/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.string;

import io.github.mmm.nls.NlsMessage;
import io.github.mmm.validation.AbstractValueValidator;
import io.github.mmm.validation.main.NlsBundleValidation;
import io.github.mmm.validation.string.ValidatorIpV4Address;
import io.github.mmm.validation.string.ValidatorIpV6Address;

public final class ValidatorIpAddress
extends AbstractValueValidator<CharSequence> {
    private static final ValidatorIpAddress INSTANCE = new ValidatorIpAddress();
    public static final String ID = "IP-Address";

    private ValidatorIpAddress() {
    }

    public String getId() {
        return ID;
    }

    protected NlsMessage validateNotNull(CharSequence value) {
        if (ValidatorIpAddress.isValidIpAddress(value.toString().trim())) {
            return null;
        }
        return NlsBundleValidation.INSTANCE.errorNoIpAddress(value);
    }

    static boolean isValidIpAddress(String value) {
        if (value.contains(":")) {
            return ValidatorIpV6Address.isValidIpV6Address(value);
        }
        return ValidatorIpV4Address.isValidIpV4Address(value);
    }

    public static ValidatorIpAddress get() {
        return INSTANCE;
    }
}

