/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.string;

import io.github.mmm.nls.NlsMessage;
import io.github.mmm.validation.AbstractValueValidator;
import io.github.mmm.validation.main.NlsBundleValidation;
import io.github.mmm.validation.string.StringHelper;

public final class ValidatorIpV4Address
extends AbstractValueValidator<CharSequence> {
    private static final ValidatorIpV4Address INSTANCE = new ValidatorIpV4Address();
    public static final String ID = "IPv4-Address";

    private ValidatorIpV4Address() {
    }

    public String getId() {
        return ID;
    }

    protected NlsMessage validateNotNull(CharSequence value) {
        if (ValidatorIpV4Address.isValidIpV4Address(value.toString().trim())) {
            return null;
        }
        return NlsBundleValidation.INSTANCE.errorNoIpAddress(value);
    }

    static boolean isValidIpV4Address(String value) {
        value = StringHelper.unbracket(value);
        String[] segments = StringHelper.splitHost(value);
        return ValidatorIpV4Address.isValidIpV4Address(segments);
    }

    static boolean isValidIpV4Address(String[] segments) {
        if (segments.length != 4) {
            return false;
        }
        for (String segment : segments) {
            if (ValidatorIpV4Address.isValidIpV4Segment(segment)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidIpV4Segment(String segment) {
        int length = segment.length();
        if (length <= 0 || length > 3) {
            return false;
        }
        boolean limited = length == 3;
        for (int i = 0; i < length; ++i) {
            char c = segment.charAt(i);
            if (c < '0' || c >= '9') {
                return false;
            }
            if (!limited) continue;
            if (i == 0) {
                if (c > '2') {
                    return false;
                }
                if (c >= '2') continue;
                limited = false;
                continue;
            }
            if (i == 1) {
                if (c > '5') {
                    return false;
                }
                if (c >= '5') continue;
                limited = false;
                continue;
            }
            if (c <= '5') continue;
            return false;
        }
        return true;
    }

    public static ValidatorIpV4Address get() {
        return INSTANCE;
    }
}

