/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.string;

import io.github.mmm.base.filter.CharFilter;
import io.github.mmm.nls.NlsMessage;
import io.github.mmm.validation.AbstractValueValidator;
import io.github.mmm.validation.main.NlsBundleValidation;
import io.github.mmm.validation.string.StringHelper;

public final class ValidatorIpV6Address
extends AbstractValueValidator<CharSequence> {
    private static final ValidatorIpV6Address INSTANCE = new ValidatorIpV6Address();
    public static final String ID = "IPv6-Address";

    private ValidatorIpV6Address() {
    }

    public String getId() {
        return ID;
    }

    protected NlsMessage validateNotNull(CharSequence value) {
        if (ValidatorIpV6Address.isValidIpV6Address(value.toString().trim())) {
            return null;
        }
        return NlsBundleValidation.INSTANCE.errorNoIpAddress(value);
    }

    static boolean isValidIpV6Address(String value) {
        int length = (value = StringHelper.unbracket(value)).length();
        if (length == 0) {
            return false;
        }
        int percentIndex = value.indexOf(37);
        if (percentIndex > 0) {
            String zone = value.substring(percentIndex + 1);
            if (!ValidatorIpV6Address.isValidZone(zone)) {
                return false;
            }
            value = value.substring(0, percentIndex);
            length = percentIndex;
        }
        int groupCount = 0;
        int colonCount = 0;
        int digitCount = 0;
        int i = 0;
        int doubleColonCount = 0;
        while (i < length) {
            char c;
            if ((c = value.charAt(i++)) == ':') {
                if (digitCount > 0) {
                    ++groupCount;
                    digitCount = 0;
                }
                if (++colonCount == 2) {
                    ++doubleColonCount;
                    continue;
                }
                if (colonCount <= 2) continue;
                return false;
            }
            if (CharFilter.HEX_DIGIT.accept((int)c)) {
                colonCount = 0;
                if (++digitCount <= 4) continue;
                return false;
            }
            return false;
        }
        if (colonCount == 1) {
            return false;
        }
        if (digitCount > 0) {
            ++groupCount;
        }
        if (groupCount + doubleColonCount > 8) {
            return false;
        }
        return groupCount >= 8 || doubleColonCount != 0;
    }

    private static boolean isValidZone(String zoneIndex) {
        return true;
    }

    public static ValidatorIpV6Address get() {
        return INSTANCE;
    }
}

