/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.string;

import io.github.mmm.base.i18n.Localizable;
import io.github.mmm.nls.NlsMessage;
import io.github.mmm.validation.AbstractValueValidator;
import io.github.mmm.validation.main.NlsBundleValidation;
import java.util.Objects;
import java.util.function.Supplier;

public class ValidatorPasswordConfirmation
extends AbstractValueValidator<CharSequence> {
    public static final String ID = "PwdConfirm";
    private final Supplier<? extends CharSequence> passwordSupplier;

    public ValidatorPasswordConfirmation(Supplier<? extends CharSequence> passwordSupplier) {
        this.passwordSupplier = passwordSupplier;
    }

    public String getId() {
        return ID;
    }

    protected Localizable validateNull() {
        return this.doValidate(null);
    }

    protected NlsMessage validateNotNull(CharSequence value) {
        return this.doValidate(value);
    }

    private NlsMessage doValidate(CharSequence confirmationPassword) {
        CharSequence primaryPassword = this.passwordSupplier.get();
        if (!Objects.equals(confirmationPassword, primaryPassword)) {
            return NlsBundleValidation.INSTANCE.errorPasswordMismatch();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ValidatorPasswordConfirmation other = (ValidatorPasswordConfirmation)((Object)obj);
        return this.passwordSupplier == other.passwordSupplier;
    }
}

