/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.string;

import io.github.mmm.nls.NlsMessage;
import io.github.mmm.validation.AbstractValueValidator;
import io.github.mmm.validation.main.NlsBundleValidation;
import java.util.Objects;
import java.util.regex.Pattern;

public class ValidatorPattern
extends AbstractValueValidator<CharSequence> {
    public static final String ID = "Pattern";
    private final Pattern pattern;

    public ValidatorPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public ValidatorPattern(String pattern) {
        this(Pattern.compile(pattern));
    }

    public String getId() {
        return ID;
    }

    protected NlsMessage validateNotNull(CharSequence value) {
        boolean matches = this.pattern.matcher(value).matches();
        if (!matches) {
            return NlsBundleValidation.INSTANCE.errorValueFormat(value, this.pattern);
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pattern);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ValidatorPattern other = (ValidatorPattern)((Object)obj);
        return Objects.equals(this.pattern, other.pattern);
    }
}

