/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.string;

import io.github.mmm.nls.NlsMessage;
import io.github.mmm.validation.AbstractValueValidator;
import io.github.mmm.validation.main.NlsBundleValidation;
import java.util.regex.Pattern;

public final class ValidatorPhoneNumber
extends AbstractValueValidator<CharSequence> {
    private static final ValidatorPhoneNumber INSTANCE = new ValidatorPhoneNumber();
    private static final Pattern PATTERN = Pattern.compile("^([+][0-9]{1,4}[ ]*(\\(0\\))?)?[-\\s/0-9]*$");
    public static final String ID = "PhoneNumber";

    private ValidatorPhoneNumber() {
    }

    public String getId() {
        return ID;
    }

    protected NlsMessage validateNotNull(CharSequence value) {
        if (ValidatorPhoneNumber.isValidPhoneNumber(value.toString().trim())) {
            return null;
        }
        return NlsBundleValidation.INSTANCE.errorNoPhoneNumber(value);
    }

    static boolean isValidPhoneNumber(String value) {
        return PATTERN.matcher(value).matches();
    }

    public static ValidatorPhoneNumber get() {
        return INSTANCE;
    }
}

