/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.string;

import io.github.mmm.nls.NlsMessage;
import io.github.mmm.validation.AbstractValueValidator;
import io.github.mmm.validation.main.NlsBundleValidation;
import io.github.mmm.validation.string.ValidatorHost;

public final class ValidatorUrl
extends AbstractValueValidator<CharSequence> {
    private static final ValidatorUrl INSTANCE = new ValidatorUrl();
    public static final String ID = "URL";

    private ValidatorUrl() {
    }

    public String getId() {
        return ID;
    }

    protected NlsMessage validateNotNull(CharSequence value) {
        if (ValidatorUrl.isValidUrl(value.toString().trim())) {
            return null;
        }
        return NlsBundleValidation.INSTANCE.errorNoUrl(value);
    }

    static boolean isValidUrl(String value) {
        int portIndex;
        String protocol = "http";
        int length = value.length();
        int protocolIndex = value.indexOf(58);
        if (protocolIndex >= 0) {
            protocol = value.substring(0, protocolIndex);
            ++protocolIndex;
            for (int slashes = 0; slashes < 2 && protocolIndex <= length && value.charAt(protocolIndex) == '/'; ++protocolIndex, ++slashes) {
            }
        } else {
            protocolIndex = 0;
        }
        if (!ValidatorUrl.isValidProtocol(protocol)) {
            return false;
        }
        int userIndex = value.indexOf(64, protocolIndex);
        if (userIndex < 0) {
            userIndex = protocolIndex;
        } else {
            String userInfo = value.substring(protocolIndex, userIndex);
            if (!ValidatorUrl.isValidUserInfo(userInfo)) {
                return false;
            }
        }
        int pathIndex = value.indexOf(47, userIndex);
        if (pathIndex >= 0) {
            int queryIndex = value.indexOf(63, pathIndex);
            if (queryIndex < 0) {
                queryIndex = length;
            } else {
                String query = value.substring(queryIndex);
                if (!ValidatorUrl.isValidQuery(query)) {
                    return false;
                }
            }
            String path = value.substring(pathIndex, queryIndex);
            if (!ValidatorUrl.isValidPath(path)) {
                return false;
            }
        } else {
            pathIndex = length;
        }
        if ((portIndex = value.indexOf(58, userIndex)) < 0) {
            portIndex = pathIndex;
        } else {
            String port = value.substring(portIndex, pathIndex);
            if (!ValidatorUrl.isValidPort(port)) {
                portIndex = pathIndex;
            }
        }
        String host = value.substring(userIndex, portIndex);
        return ValidatorHost.isValidHost(host);
    }

    private static boolean isValidProtocol(String protocol) {
        return true;
    }

    private static boolean isValidUserInfo(String userInfo) {
        return true;
    }

    private static boolean isValidPort(String port) {
        int length = port.length();
        if (length == 0 || length > 5) {
            return false;
        }
        int portNumber = 0;
        int leadingZeros = 0;
        for (int i = 0; i < length; ++i) {
            char c = port.charAt(i);
            if (c < '0') {
                return false;
            }
            if (c > '9') {
                return false;
            }
            if (c == '0') {
                if (leadingZeros < 0) continue;
                ++leadingZeros;
                continue;
            }
            portNumber = portNumber * 10 + (c - 48);
            if (leadingZeros < 0) continue;
            if (length - leadingZeros > 5) {
                return false;
            }
            leadingZeros = -1;
        }
        return portNumber <= 65535;
    }

    private static boolean isValidPath(String path) {
        return true;
    }

    private static boolean isValidQuery(String path) {
        return true;
    }

    public static ValidatorUrl get() {
        return INSTANCE;
    }
}

