/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.time;

import io.github.mmm.nls.NlsMessage;
import io.github.mmm.validation.AbstractValueValidator;
import io.github.mmm.validation.main.NlsBundleValidation;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class ValidatorTemporalAfter<V extends Comparable<?>>
extends AbstractValueValidator<V> {
    public static final String ID = "After";
    private final Supplier<V> boundSource;
    private final V bound;

    public ValidatorTemporalAfter(Supplier<V> valueSource) {
        Objects.requireNonNull(valueSource, "valueSource");
        this.boundSource = valueSource;
        this.bound = null;
    }

    public ValidatorTemporalAfter(V value) {
        Objects.requireNonNull(value, "value");
        this.boundSource = null;
        this.bound = value;
    }

    public boolean isDynamic() {
        return this.boundSource != null;
    }

    public String getId() {
        return ID;
    }

    protected NlsMessage validateNotNull(V value) {
        Object limit = this.boundSource == null ? this.bound : (Comparable)this.boundSource.get();
        if (this.isAfter(value, limit)) {
            return null;
        }
        return NlsBundleValidation.INSTANCE.errorValueNotBefore(value, limit);
    }

    protected abstract boolean isAfter(V var1, V var2);

    public V getMin() {
        return this.bound;
    }

    private Object getSource() {
        if (this.boundSource == null) {
            return this.bound;
        }
        return this.boundSource;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSource());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ValidatorTemporalAfter other = (ValidatorTemporalAfter)((Object)obj);
        return Objects.equals(this.getSource(), other.getSource());
    }
}

