/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation.time.localdatetime;

import io.github.mmm.validation.time.ValidatorBuilderTemporal;
import io.github.mmm.validation.time.localdatetime.ValidatorLocalDateTimeAfter;
import io.github.mmm.validation.time.localdatetime.ValidatorLocalDateTimeBefore;
import io.github.mmm.validation.time.localdatetime.ValidatorLocalDateTimeFuture;
import io.github.mmm.validation.time.localdatetime.ValidatorLocalDateTimePast;
import java.time.LocalDateTime;
import java.util.function.Supplier;

public class ValidatorBuilderLocalDateTime<PARENT>
extends ValidatorBuilderTemporal<LocalDateTime, PARENT, ValidatorBuilderLocalDateTime<PARENT>> {
    public ValidatorBuilderLocalDateTime(PARENT parent) {
        super(parent);
    }

    @Override
    protected LocalDateTime parse(String value) {
        return LocalDateTime.parse(value);
    }

    @Override
    public ValidatorBuilderLocalDateTime<PARENT> past() {
        return (ValidatorBuilderLocalDateTime)this.add(new ValidatorLocalDateTimePast());
    }

    @Override
    public ValidatorBuilderLocalDateTime<PARENT> future() {
        return (ValidatorBuilderLocalDateTime)this.add(new ValidatorLocalDateTimeFuture());
    }

    @Override
    public ValidatorBuilderLocalDateTime<PARENT> after(LocalDateTime value) {
        return (ValidatorBuilderLocalDateTime)this.add(new ValidatorLocalDateTimeAfter(value));
    }

    @Override
    public ValidatorBuilderLocalDateTime<PARENT> after(Supplier<LocalDateTime> valueSource) {
        return (ValidatorBuilderLocalDateTime)this.add(new ValidatorLocalDateTimeAfter(valueSource));
    }

    @Override
    public ValidatorBuilderLocalDateTime<PARENT> before(LocalDateTime value) {
        return (ValidatorBuilderLocalDateTime)this.add(new ValidatorLocalDateTimeBefore(value));
    }

    @Override
    public ValidatorBuilderLocalDateTime<PARENT> before(Supplier<LocalDateTime> valueSource) {
        return (ValidatorBuilderLocalDateTime)this.add(new ValidatorLocalDateTimeBefore(valueSource));
    }
}

