/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation;

import io.github.mmm.base.range.Range;
import io.github.mmm.validation.AbstractValidator;
import io.github.mmm.validation.ComposedValidator;
import io.github.mmm.validation.ValidationResult;
import io.github.mmm.validation.ValidationResultBuilder;
import io.github.mmm.validation.Validator;
import java.util.Objects;

public abstract class AbstractComposedValidator<V, C>
extends AbstractValidator<V> {
    protected final Validator<? super C>[] children;

    @SafeVarargs
    public AbstractComposedValidator(Validator<? super C> ... validators) {
        this.children = validators;
    }

    protected ValidationResult validateChild(C value, String valueSource) {
        ValidationResultBuilder builder = new ValidationResultBuilder(false);
        this.validateChild(value, valueSource, builder);
        return builder.build(valueSource);
    }

    protected void validateChild(C value, String valueSource, ValidationResultBuilder builder) {
        for (Validator<C> validator : this.children) {
            ValidationResult failure = validator.validate(value, valueSource);
            builder.add(failure);
        }
    }

    @Override
    public int getChildCount() {
        return this.children.length;
    }

    @Override
    public Validator<? super C> getChild(int index) {
        if (index >= 0 && index < this.children.length) {
            return this.children[index];
        }
        return null;
    }

    @Override
    public <T> Validator<T> append(Validator<?> validator) {
        if (validator == null || validator == Validator.none()) {
            return this;
        }
        if (this instanceof ComposedValidator) {
            Validator[] composed = new Validator[this.children.length + 1];
            System.arraycopy(this.children, 0, composed, 0, this.children.length);
            composed[this.children.length] = validator;
            return new ComposedValidator(composed);
        }
        return new ComposedValidator(new Validator[]{this, validator});
    }

    @Override
    public <T> Validator<T> append(Validator<?> ... validators) {
        if (validators == null || validators.length == 0) {
            return this;
        }
        if (validators.length == 1 && validators[0] == Validator.none()) {
            return this;
        }
        if (this instanceof ComposedValidator) {
            Validator[] composed = new Validator[this.children.length + validators.length];
            System.arraycopy(this.children, 0, composed, 0, this.children.length);
            System.arraycopy(validators, 0, composed, this.children.length, validators.length);
            return new ComposedValidator(composed);
        }
        return super.append(validators);
    }

    @Override
    public boolean containsId(String id) {
        if (super.containsId(id)) {
            return true;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Object child = this.getChild(i);
            if (!child.containsId(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T getChild(Class<T> validatorClass) {
        T validator = super.getChild(validatorClass);
        if (validator == null) {
            Object child;
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount && (validator = (child = this.getChild(i)).getChild(validatorClass)) == null; ++i) {
            }
        }
        return validator;
    }

    @Override
    public <T extends Comparable<?>> Range<T> getRange() {
        Range range = Range.unbounded();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Object child = this.getChild(i);
            Range range2 = child.getRange();
            range = range.intersection(range2);
        }
        return range;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.children);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractComposedValidator other = (AbstractComposedValidator)obj;
        return Objects.equals(this.children, other.children);
    }
}

