/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation;

import io.github.mmm.base.exception.RuntimeIoException;
import io.github.mmm.validation.AbstractValidationResult;
import io.github.mmm.validation.ValidationResult;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;

public class ComposedValidationFailure
extends AbstractValidationResult {
    public static final String CODE = "Composed";
    private final ValidationResult[] failures;
    private final boolean appendSources;

    public ComposedValidationFailure(String source, ValidationResult ... failures) {
        this(CODE, source, false, failures);
    }

    public ComposedValidationFailure(String source, boolean appendSources, ValidationResult ... failures) {
        this(CODE, source, appendSources, failures);
    }

    public ComposedValidationFailure(String code, String source, boolean appendSources, ValidationResult ... failures) {
        super(code, source);
        assert (ComposedValidationFailure.onlyFailures(failures));
        this.appendSources = appendSources;
        this.failures = failures;
    }

    public boolean isAppendSources() {
        return this.appendSources;
    }

    private static boolean onlyFailures(ValidationResult[] failures) {
        for (ValidationResult failure : failures) {
            if (!failure.isValid()) continue;
            return false;
        }
        return true;
    }

    protected String getSeparator() {
        return "\n";
    }

    public int getChildCount() {
        return this.failures.length;
    }

    public ValidationResult getChild(int index) {
        if (index >= 0 && index < this.failures.length) {
            return this.failures[index];
        }
        return null;
    }

    @Override
    public void getLocalizedMessage(Locale locale, Appendable buffer, boolean verbose) {
        this.getLocalizedMessage("", locale, buffer, verbose, this.appendSources);
    }

    protected void getLocalizedMessage(String indent, Locale locale, Appendable buffer, boolean verbose, boolean appendSrc) {
        try {
            String separator = null;
            boolean appended = this.appendSource((String)indent, appendSrc, this, buffer);
            if (verbose) {
                if (!appended) {
                    buffer.append((CharSequence)indent);
                    appended = true;
                }
                this.appendCode(buffer, false);
            }
            if (appended) {
                separator = this.getSeparator();
            }
            indent = (String)indent + "  ";
            for (ValidationResult failure : this.failures) {
                if (separator == null) {
                    separator = this.getSeparator();
                } else {
                    buffer.append(separator);
                }
                if (failure instanceof ComposedValidationFailure) {
                    ((ComposedValidationFailure)failure).getLocalizedMessage((String)indent, locale, buffer, verbose, appendSrc);
                    continue;
                }
                this.appendSource((String)indent, appendSrc, failure, buffer);
                failure.getLocalizedMessage(locale, buffer, verbose);
            }
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e);
        }
    }

    private boolean appendSource(String indent, boolean appendSrc, ValidationResult result, Appendable buffer) throws IOException {
        String source;
        if (appendSrc && result != null && !result.isValid() && (source = result.getSource()) != null && !source.isEmpty()) {
            buffer.append(indent);
            buffer.append(source);
            buffer.append(": ");
            return true;
        }
        return false;
    }

    @Override
    public ValidationResult add(ValidationResult result) {
        ValidationResult[] composedFailures;
        if (result == null || result.isValid()) {
            return this;
        }
        if (result instanceof ComposedValidationFailure) {
            ValidationResult[] otherFailures = ((ComposedValidationFailure)result).failures;
            composedFailures = Arrays.copyOf(this.failures, this.failures.length + otherFailures.length);
            System.arraycopy(otherFailures, 0, composedFailures, this.failures.length, otherFailures.length);
        } else {
            composedFailures = Arrays.copyOf(this.failures, this.failures.length + 1);
            composedFailures[this.failures.length] = result;
        }
        return new ComposedValidationFailure(this.getSource(), composedFailures);
    }

    @Override
    public boolean containsCode(String code) {
        if (super.containsCode(code)) {
            return true;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ValidationResult child = this.getChild(i);
            if (!child.containsCode(code)) continue;
            return true;
        }
        return false;
    }
}

