/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation;

import io.github.mmm.base.i18n.Localizable;
import io.github.mmm.validation.AbstractValidationResult;
import io.github.mmm.validation.ComposedValidationFailure;
import io.github.mmm.validation.ValidationResult;
import java.util.Locale;
import java.util.Objects;

public class ValidationFailure
extends AbstractValidationResult {
    private final Localizable message;

    public ValidationFailure(String code, Localizable message) {
        this(code, message, null);
    }

    public ValidationFailure(String code, Localizable message, String source) {
        super(code, source);
        Objects.requireNonNull(message, "message");
        this.message = message;
    }

    public int getChildCount() {
        return 0;
    }

    public ValidationResult getChild(int index) {
        return null;
    }

    @Override
    public String getMessage() {
        return this.message.getMessage();
    }

    public String getLocalizedMessage() {
        return this.message.getLocalizedMessage();
    }

    public String getLocalizedMessage(Locale locale) {
        return this.message.getLocalizedMessage(locale);
    }

    @Override
    public void getLocalizedMessage(Locale locale, Appendable buffer, boolean verbose) {
        if (verbose) {
            this.appendCode(buffer, true);
        }
        this.message.getLocalizedMessage(locale, buffer);
    }

    @Override
    public ValidationResult add(ValidationResult result) {
        if (result == null || result.isValid()) {
            return this;
        }
        if (result instanceof ComposedValidationFailure) {
            return result.add(this);
        }
        return new ComposedValidationFailure(this.getSource(), this, result);
    }
}

