/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation;

import io.github.mmm.validation.ComposedValidationFailure;
import io.github.mmm.validation.ValidationResult;
import io.github.mmm.validation.ValidationResultValid;
import java.util.ArrayList;
import java.util.List;

public class ValidationResultBuilder {
    private final boolean appendSources;
    private ValidationResult result;
    private List<ValidationResult> failureList;

    public ValidationResultBuilder() {
        this(true);
    }

    public ValidationResultBuilder(boolean appendSources) {
        this.appendSources = appendSources;
        this.result = ValidationResultValid.get();
    }

    public void add(ValidationResult validationResult) {
        if (validationResult == null || validationResult.isValid()) {
            return;
        }
        if (this.failureList == null) {
            if (this.result.isValid()) {
                this.result = validationResult;
            } else {
                this.failureList = new ArrayList<ValidationResult>();
                this.failureList.add(this.result);
            }
        }
        if (this.failureList != null) {
            this.failureList.add(validationResult);
        }
    }

    public ValidationResult build(String valueSource) {
        if (this.failureList != null) {
            this.result = new ComposedValidationFailure(valueSource, this.appendSources, this.failureList.toArray(new ValidationResult[this.failureList.size()]));
        } else if (!(this.result.isValid() || valueSource == null || valueSource.isEmpty() || valueSource.equals(this.result.getSource()))) {
            return new ComposedValidationFailure(valueSource, this.appendSources, this.result);
        }
        return this.result;
    }
}

