/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.validation;

import io.github.mmm.base.lang.Composable;
import io.github.mmm.base.range.Range;
import io.github.mmm.validation.ComposedValidator;
import io.github.mmm.validation.ValidationResult;
import io.github.mmm.validation.impl.ValidatorNone;

public interface Validator<V>
extends Composable<Validator<?>> {
    public static final String ID_MANDATORY = "Mandatory";

    default public ValidationResult validate(V value) {
        return this.validate(value, null);
    }

    public ValidationResult validate(V var1, Object var2);

    public String getId();

    default public boolean isMandatory() {
        return this.containsId(ID_MANDATORY);
    }

    default public boolean containsId(String id) {
        return this.getId().equals(id);
    }

    default public <T> T getChild(Class<T> validatorClass) {
        if (this.getClass().equals(validatorClass)) {
            return validatorClass.cast(this);
        }
        return null;
    }

    default public <T extends Comparable<?>> Range<T> getRange() {
        return Range.unbounded();
    }

    default public <T extends Comparable<?>> T getMin() {
        return (T)this.getRange().getMin();
    }

    default public <T extends Comparable<?>> T getMax() {
        return (T)this.getRange().getMax();
    }

    default public <T> Validator<T> append(Validator<?> validator) {
        if (validator == null || validator == Validator.none()) {
            return this;
        }
        return new ComposedValidator(new Validator[]{this, validator});
    }

    default public <T> Validator<T> append(Validator<?> ... validators) {
        if (validators == null || validators.length == 0) {
            return this;
        }
        if (validators.length == 1) {
            if (validators[0] == Validator.none()) {
                return this;
            }
            return new ComposedValidator(new Validator[]{this, validators[0]});
        }
        Validator[] children = new Validator[validators.length + 1];
        children[0] = this;
        System.arraycopy(validators, 0, children, 1, validators.length);
        return new ComposedValidator((Validator<? super V>[])validators);
    }

    public static <T> Validator<T> none() {
        return ValidatorNone.INSTANCE;
    }

    public static boolean isValidating(Validator<?> validator) {
        if (validator == null) {
            return false;
        }
        return validator != ValidatorNone.INSTANCE;
    }
}

