/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.value.impl;

import io.github.mmm.value.ReadablePath;
import java.util.Objects;

public class PathBuilderImpl
implements ReadablePath.PathBuilder {
    private final String separator;
    private final StringBuilder buffer;

    public PathBuilderImpl(String separator) {
        Objects.requireNonNull(separator, "separator");
        if (separator.isEmpty()) {
            throw new IllegalArgumentException("Separator must not be empty!");
        }
        this.separator = separator;
        this.buffer = new StringBuilder();
    }

    @Override
    public void add(String segment) {
        if (segment == null || segment.isEmpty()) {
            return;
        }
        if (this.buffer.length() > 0) {
            this.buffer.append(this.separator);
        }
        assert (segment != null && !segment.isEmpty());
        this.buffer.append(segment);
    }

    @Override
    public String toString() {
        return this.buffer.toString();
    }
}

