/*
 * Decompiled with CFR 0.152.
 */
package org.m2ci.msp.jtgt;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.json.JSONObject;
import org.m2ci.msp.jtgt.Annotation;

public abstract class Tier {
    private ArrayList<Annotation> annotations;
    private double start;
    private double end;
    private String name;

    protected Tier(String name) {
        this.setStart(-1.0);
        this.setEnd(-1.0);
        this.setName(name);
        this.setAnnotations(new ArrayList<Annotation>());
    }

    protected Tier(String name, double start, double end, ArrayList<Annotation> annotations) {
        this.setName(name);
        this.setStart(start);
        this.setEnd(end);
        this.setAnnotations(annotations);
    }

    public double getStart() {
        return this.start;
    }

    public double getEnd() {
        return this.end;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setStart(double start) {
        this.start = start;
    }

    public void setEnd(double end) {
        this.end = end;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAnnotations(ArrayList<Annotation> annotations) {
        this.annotations = annotations;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        if (this.getEnd() < annotation.getEnd()) {
            this.setEnd(annotation.getEnd());
        }
    }

    public void addAnnotations(ArrayList<Annotation> annotations) {
        Annotation end_it = null;
        Iterator<Annotation> iterator = annotations.iterator();
        while (iterator.hasNext()) {
            Annotation an;
            end_it = an = iterator.next();
            this.annotations.add(an);
        }
        if (end_it != null && this.getEnd() < end_it.getEnd()) {
            this.setEnd(end_it.getEnd());
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Tier)) {
            return false;
        }
        return this.getStart() == ((Tier)o).getStart() && this.getEnd() == ((Tier)o).getEnd() && this.getName().equals(((Tier)o).getName()) && this.getAnnotations().equals(((Tier)o).getAnnotations());
    }

    public String toString() {
        String jsonStr = new ReflectionToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).toString();
        return new JSONObject(jsonStr).toString(4);
    }
}

