/*
 * Decompiled with CFR 0.152.
 */
package org.m2ci.msp.jtgt.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.m2ci.msp.jtgt.Annotation;
import org.m2ci.msp.jtgt.TextGrid;
import org.m2ci.msp.jtgt.Tier;
import org.m2ci.msp.jtgt.annotation.IntervalAnnotation;
import org.m2ci.msp.jtgt.annotation.PointAnnotation;
import org.m2ci.msp.jtgt.io.TextGridIOException;
import org.m2ci.msp.jtgt.tier.IntervalTier;
import org.m2ci.msp.jtgt.tier.PointTier;

public class TextGridSerializer {
    private static final String DEFAULT_LINE_SEPARATOR = "\n";
    private static final String LINE_SEPARATOR_PATTERN = "[\\n\\r]+";
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("^[ \t]*(\\p{Alnum}+)[ \t]*=[ \t]*\"?([^\"]*)\"?");
    private static final Pattern TIER_PATTERN = Pattern.compile("^[ \t]*item[ \t]*\\[[0-9]+\\][ \t]*:.*");
    private static final Pattern INTERVALS_PATTERN = Pattern.compile("^[ \t]*intervals[ \t]*:[ \t]*size[ \t]*=[ \t]*([0-9]+)");
    private static final Pattern INTERVAL_ITEM_PATTERN = Pattern.compile("^[ \t]*intervals[ \t]*\\[[0-9]+\\][ \t]*:.*");
    private static final Pattern POINTS_PATTERN = Pattern.compile("^[ \t]*points[ \t]*:[ \t]*size[ \t]*=[ \t]*([0-9]+)");
    private static final Pattern POINT_ITEM_PATTERN = Pattern.compile("^[ \t]*points[ \t]*\\[[0-9]+\\][ \t]*:.*");

    public TextGrid fromString(String str_tgt) throws TextGridIOException {
        ArrayList<Tier> tiers;
        double xmax;
        double xmin;
        TextGrid tgt = new TextGrid();
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(str_tgt.split("[\\n\\r]++")));
        String tmp_line = lines.remove(0);
        if (!tmp_line.equals("File type = \"ooTextFile\"")) {
            throw new TextGridIOException("Header is not correctly formatted (" + tmp_line + ")");
        }
        tmp_line = lines.remove(0);
        if (!tmp_line.equals("Object class = \"TextGrid\"")) {
            throw new TextGridIOException("Header is not correctly formatted (" + tmp_line + ")");
        }
        if (lines.get(0).startsWith("xmin")) {
            String tmp = lines.remove(0);
            Matcher m = PROPERTY_PATTERN.matcher(tmp);
            if (!m.find()) {
                throw new TextGridIOException("start line is not correctly formatted");
            }
            xmin = Double.parseDouble(m.group(2));
            tmp = lines.remove(0);
            m = PROPERTY_PATTERN.matcher(tmp);
            if (!m.find()) {
                throw new TextGridIOException("end line is not correctly formatted");
            }
            xmax = Double.parseDouble(m.group(2));
            lines.remove(0);
            tmp = lines.remove(0);
            m = PROPERTY_PATTERN.matcher(tmp);
            if (!m.find()) {
                throw new TextGridIOException("nb_tiers line is not correctly formatted");
            }
            int nb_tiers = Integer.parseInt(m.group(2).trim());
            lines.remove(0);
            tiers = this.readLongTextGrid(lines);
            if (tiers.size() != nb_tiers) {
                throw new TextGridIOException("Inconsistency between the number of tiers parsed (" + tiers.size() + ") and the expected number of tiers (" + nb_tiers + ")");
            }
        } else {
            throw new TextGridIOException("Short format not supported yet or invalid line: \"" + lines.get(0) + "\"");
        }
        tgt = new TextGrid(xmin, xmax, tiers);
        return tgt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList<Tier> readLongTextGrid(List<String> lines) throws TextGridIOException {
        ArrayList<Tier> tiers = new ArrayList<Tier>();
        Matcher m = TIER_PATTERN.matcher(lines.get(0));
        while (m.find()) {
            Tier t;
            lines.remove(0);
            m = PROPERTY_PATTERN.matcher(lines.remove(0));
            if (!m.find() || !"class".equals(m.group(1))) throw new TextGridIOException("The class of the tier should be defined here");
            if ("IntervalTier".equals(m.group(2))) {
                t = this.readLongIntervalTier(lines);
            } else {
                if (!"TextTier".equals(m.group(2))) throw new TextGridIOException("Unknown class of tier");
                t = this.readLongPointTier(lines);
            }
            tiers.add(t);
            if (lines.size() == 0) return tiers;
            m = TIER_PATTERN.matcher(lines.get(0));
        }
        return tiers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tier readLongIntervalTier(List<String> lines) throws TextGridIOException {
        double start = -1.0;
        double end = -1.0;
        String name = null;
        Object type = null;
        Matcher m = INTERVALS_PATTERN.matcher(lines.get(0));
        while (!m.find()) {
            String line = lines.get(0);
            m = PROPERTY_PATTERN.matcher(line);
            if (m.find()) {
                if (m.group(1).equals("name")) {
                    name = m.group(2);
                } else if (m.group(1).equals("xmin")) {
                    start = Double.parseDouble(m.group(2));
                } else {
                    if (!m.group(1).equals("xmax")) throw new TextGridIOException("Property " + m.group(1) + " is unknown for a tier");
                    end = Double.parseDouble(m.group(2));
                }
            } else {
                m = INTERVALS_PATTERN.matcher(line);
                if (!m.find()) {
                    throw new TextGridIOException("A property is expected here: " + line);
                }
            }
            lines.remove(0);
            m = INTERVALS_PATTERN.matcher(lines.get(0));
        }
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        lines.remove(0);
        m = INTERVAL_ITEM_PATTERN.matcher(lines.get(0));
        while (m.find()) {
            lines.remove(0);
            double start_an = -1.0;
            double end_an = -1.0;
            String text = null;
            m = PROPERTY_PATTERN.matcher(lines.get(0));
            while (m.find()) {
                lines.remove(0);
                if (m.group(1).equals("text")) {
                    text = m.group(2);
                } else if (m.group(1).equals("xmin")) {
                    start_an = Double.parseDouble(m.group(2));
                } else {
                    if (!m.group(1).equals("xmax")) throw new TextGridIOException("Property " + m.group(1) + " is unknown for an annotation");
                    end_an = Double.parseDouble(m.group(2));
                }
                if (lines.size() == 0) break;
                m = PROPERTY_PATTERN.matcher(lines.get(0));
            }
            IntervalAnnotation annotation = new IntervalAnnotation(start_an, end_an, text);
            annotations.add(annotation);
            if (lines.size() == 0) return new IntervalTier(name, start, end, annotations);
            m = INTERVAL_ITEM_PATTERN.matcher(lines.get(0));
        }
        return new IntervalTier(name, start, end, annotations);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tier readLongPointTier(List<String> lines) throws TextGridIOException {
        double start = -1.0;
        double end = -1.0;
        String name = null;
        Object type = null;
        Matcher m = POINTS_PATTERN.matcher(lines.get(0));
        while (!m.find()) {
            String line = lines.get(0);
            m = PROPERTY_PATTERN.matcher(line);
            if (m.find()) {
                if (m.group(1).equals("name")) {
                    name = m.group(2);
                } else if (m.group(1).equals("xmin")) {
                    start = Double.parseDouble(m.group(2));
                } else {
                    if (!m.group(1).equals("xmax")) throw new TextGridIOException("Property " + m.group(1) + " is unknown for a tier");
                    end = Double.parseDouble(m.group(2));
                }
            } else {
                m = POINTS_PATTERN.matcher(line);
                if (!m.find()) {
                    throw new TextGridIOException("A property is expected here: " + line);
                }
            }
            lines.remove(0);
            m = POINTS_PATTERN.matcher(lines.get(0));
        }
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        lines.remove(0);
        m = POINT_ITEM_PATTERN.matcher(lines.get(0));
        while (m.find()) {
            lines.remove(0);
            double time = -1.0;
            String text = null;
            m = PROPERTY_PATTERN.matcher(lines.get(0));
            while (m.find()) {
                lines.remove(0);
                if (m.group(1).equals("mark")) {
                    text = m.group(2);
                } else {
                    if (!m.group(1).equals("number")) throw new TextGridIOException("Property " + m.group(1) + " is unknown for an annotation");
                    time = Double.parseDouble(m.group(2));
                }
                if (lines.size() == 0) break;
                m = PROPERTY_PATTERN.matcher(lines.get(0));
            }
            PointAnnotation annotation = new PointAnnotation(time, text);
            annotations.add(annotation);
            if (lines.size() == 0) return new PointTier(name, start, end, annotations);
            m = POINT_ITEM_PATTERN.matcher(lines.get(0));
        }
        return new PointTier(name, start, end, annotations);
    }

    public String toString(TextGrid tgt) throws TextGridIOException {
        StringBuilder str_tgt = new StringBuilder();
        str_tgt.append("File type = \"ooTextFile\"\n");
        str_tgt.append("Object class = \"TextGrid\"\n");
        str_tgt.append(DEFAULT_LINE_SEPARATOR);
        str_tgt.append("xmin = " + tgt.getStart() + DEFAULT_LINE_SEPARATOR);
        str_tgt.append("xmax = " + tgt.getEnd() + DEFAULT_LINE_SEPARATOR);
        str_tgt.append("tiers? <exists>\n");
        ArrayList<Tier> tiers = tgt.getTiers();
        str_tgt.append("size = " + tiers.size() + DEFAULT_LINE_SEPARATOR);
        str_tgt.append("item []:\n");
        for (int t = 0; t < tiers.size(); ++t) {
            Annotation an;
            int a;
            Tier tier = tiers.get(t);
            str_tgt.append("\titem [" + (t + 1) + "]:" + DEFAULT_LINE_SEPARATOR);
            if (tier instanceof IntervalTier) {
                str_tgt.append("\t\tclass = \"IntervalTier\"\n");
            } else if (tier instanceof PointTier) {
                str_tgt.append("\t\tclass = \"TextTier\"\n");
            } else {
                throw new TextGridIOException(tier.getClass().toString() + " serialization is not supported");
            }
            str_tgt.append("\t\tname = \"" + tier.getName() + "\"" + DEFAULT_LINE_SEPARATOR);
            str_tgt.append("\t\txmin = " + tier.getStart() + DEFAULT_LINE_SEPARATOR);
            str_tgt.append("\t\txmax = " + tier.getEnd() + DEFAULT_LINE_SEPARATOR);
            ArrayList<Annotation> annotations = tier.getAnnotations();
            if (tier instanceof IntervalTier) {
                str_tgt.append("\t\tintervals: size = " + annotations.size() + DEFAULT_LINE_SEPARATOR);
            } else if (tier instanceof PointTier) {
                str_tgt.append("\t\tpoints: size = " + annotations.size() + DEFAULT_LINE_SEPARATOR);
            }
            if (tier instanceof IntervalTier) {
                for (a = 0; a < annotations.size(); ++a) {
                    an = (IntervalAnnotation)annotations.get(a);
                    str_tgt.append("\t\t\tintervals [" + (a + 1) + "]:" + DEFAULT_LINE_SEPARATOR);
                    str_tgt.append("\t\t\t\txmin = " + an.getStart() + DEFAULT_LINE_SEPARATOR);
                    str_tgt.append("\t\t\t\txmax = " + an.getEnd() + DEFAULT_LINE_SEPARATOR);
                    str_tgt.append("\t\t\t\ttext = \"" + an.getText() + "\"" + DEFAULT_LINE_SEPARATOR);
                }
                continue;
            }
            if (!(tier instanceof PointTier)) continue;
            for (a = 0; a < annotations.size(); ++a) {
                an = (PointAnnotation)annotations.get(a);
                str_tgt.append("\t\t\tpoints [" + (a + 1) + "]:" + DEFAULT_LINE_SEPARATOR);
                str_tgt.append("\t\t\t\tnumber = " + ((PointAnnotation)an).getTime() + DEFAULT_LINE_SEPARATOR);
                str_tgt.append("\t\t\t\tmark = \"" + an.getText() + "\"" + DEFAULT_LINE_SEPARATOR);
            }
        }
        return str_tgt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(TextGrid tgt, File output_file) throws IOException {
        IOException ex = null;
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(output_file));
            writer.write(this.toString(tgt));
        }
        catch (IOException ex_tmp) {
            ex = ex_tmp;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        if (ex != null) {
            throw ex;
        }
    }
}

