/*
 * Decompiled with CFR 0.152.
 */
package org.m2ci.msp.jtgt.io;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.m2ci.msp.jtgt.Annotation;
import org.m2ci.msp.jtgt.TextGrid;
import org.m2ci.msp.jtgt.Tier;
import org.m2ci.msp.jtgt.annotation.IntervalAnnotation;
import org.m2ci.msp.jtgt.io.TextGridIOException;
import org.m2ci.msp.jtgt.tier.IntervalTier;

public class XWaveLabelSerializer {
    private static final String DEFAULT_LINE_SEPARATOR = "\n";
    private static final String LINE_SEPARATOR_PATTERN = "[\\n\\r]+";
    private static final Pattern HEADER_SEP = Pattern.compile("^#.*");
    private static final Pattern ELT_PATTERN = Pattern.compile("^[ \t]*([0-9.]+)[ \t]*-?[0-9]+[ \t]*([^ \t]*)[ \t]*$");
    private static final String MIDDLE_VALUE = "26";

    public TextGrid fromString(String str_xwave) throws TextGridIOException {
        TextGrid tg = new TextGrid();
        String[] lines = str_xwave.split(LINE_SEPARATOR_PATTERN);
        IntervalTier the_tier = new IntervalTier("phones");
        tg.setStart(0.0);
        the_tier.setStart(0.0);
        double start = 0.0;
        boolean header_end = false;
        for (String line : lines) {
            Matcher m;
            if (!header_end) {
                m = HEADER_SEP.matcher(line);
                if (!m.find()) continue;
                header_end = true;
                continue;
            }
            m = ELT_PATTERN.matcher(line);
            if (m.find()) {
                double end = Double.parseDouble(m.group(1));
                the_tier.addAnnotation(new IntervalAnnotation(start, end, m.group(2)));
                start = end;
                continue;
            }
            throw new TextGridIOException("This line should not be in the content part: " + line);
        }
        tg.setEnd(start);
        if (the_tier.getAnnotations().size() == 0) {
            throw new TextGridIOException("No annotations found !");
        }
        tg.addTier(the_tier);
        return tg;
    }

    public String toString(TextGrid tgt, String tier_name) throws TextGridIOException {
        String str_xwav_lab = "separator ;\n";
        str_xwav_lab = str_xwav_lab + "nfields 1\n";
        str_xwav_lab = str_xwav_lab + "#\n";
        ArrayList<Tier> tiers = tgt.getTiers();
        Tier tier = null;
        boolean found = false;
        for (int t = 0; t < tiers.size() && !found; ++t) {
            tier = tiers.get(t);
            if (!tier_name.equals(tier.getName())) continue;
            found = true;
        }
        if (!found) {
            throw new TextGridIOException("Cannot find the tier \"" + tier_name + "in the textgrid\"");
        }
        if (tier instanceof IntervalTier) {
            ArrayList<Annotation> annotations = tier.getAnnotations();
            for (int a = 0; a < annotations.size(); ++a) {
                IntervalAnnotation an = (IntervalAnnotation)annotations.get(a);
                str_xwav_lab = str_xwav_lab + "\t" + an.getEnd() + " " + MIDDLE_VALUE + " " + an.getText() + DEFAULT_LINE_SEPARATOR;
            }
        } else {
            throw new TextGridIOException("Don't know how to serialize anaything execpt an IntervalTier");
        }
        return str_xwav_lab;
    }
}

