/*
 * Decompiled with CFR 0.152.
 */
package org.jamdev.jpamutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public class JamArr {
    public static double mean(ArrayList<double[]> array, double InitialtoIgnorePercentage, int dim) {
        int forStart;
        double meanTotal = 0.0;
        int n = 0;
        for (int i = forStart = (int)Math.round(InitialtoIgnorePercentage * (double)array.size()); i < array.size(); ++i) {
            meanTotal += array.get(i)[dim];
            ++n;
        }
        double mean = meanTotal / (double)n;
        return mean;
    }

    public static double std(ArrayList<double[]> array, double initialtoIgnorePercentage, int dim) {
        double std = 0.0;
        int n = 0;
        int forStart = (int)Math.round(initialtoIgnorePercentage * (double)array.size());
        double meanTotal = JamArr.mean(array, initialtoIgnorePercentage, dim);
        for (int k = forStart; k < array.size(); ++k) {
            std += Math.pow(array.get(k)[dim] - meanTotal, 2.0);
        }
        std = Math.sqrt(std / (double)(n - 1));
        return std;
    }

    public static Double mean(ArrayList<? extends Number> array, double InitialtoIgnorePercentage) {
        int forStart;
        double meanTotal = 0.0;
        int n = 0;
        for (int i = forStart = (int)Math.round(InitialtoIgnorePercentage * (double)array.size()); i < array.size(); ++i) {
            meanTotal += array.get(i).doubleValue();
            ++n;
        }
        double mean = meanTotal / (double)n;
        return mean;
    }

    public static double std(ArrayList<? extends Number> array, double initialtoIgnorePercentage) {
        int forStart;
        double Std = 0.0;
        double meanTotal = 0.0;
        int n = 0;
        for (int i = forStart = (int)Math.round(initialtoIgnorePercentage * (double)array.size()); i < array.size(); ++i) {
            meanTotal += array.get(i).doubleValue();
            ++n;
        }
        meanTotal /= (double)n;
        for (int k = forStart; k < array.size(); ++k) {
            Std += Math.pow(array.get(k).doubleValue() - meanTotal, 2.0);
        }
        double stndDev = Math.sqrt(Std / (double)(n - 1));
        return stndDev;
    }

    public static double std(ArrayList<? extends Number> array) {
        return JamArr.std(array, 0.0);
    }

    public static double median(ArrayList<? extends Number> array, double ignorePercentage) {
        int forStart;
        ArrayList<Double> arrayMedian = new ArrayList<Double>();
        for (int i = forStart = (int)Math.round(ignorePercentage * (double)array.size()); i < array.size(); ++i) {
            arrayMedian.add(array.get(i).doubleValue());
        }
        return JamArr.median(arrayMedian);
    }

    public static double median(ArrayList<? extends Number> array) {
        int size = array.size();
        ArrayList<Double> zSort = new ArrayList<Double>();
        for (int i = 0; i < array.size(); ++i) {
            zSort.add(array.get(i).doubleValue());
        }
        Collections.sort(zSort);
        double median = 0.0;
        if (size % 2 == 0) {
            double n1 = (Double)zSort.get(size / 2);
            double n2 = (Double)zSort.get(size / 2 - 1);
            median = (n1 + n2) / 2.0;
        } else {
            median = (Double)zSort.get((int)((double)(size / 2) - 0.5));
        }
        return median;
    }

    public static double median(double[] numArray) {
        Arrays.sort(numArray);
        double median = numArray.length % 2 == 0 ? (numArray[numArray.length / 2] + numArray[numArray.length / 2 - 1]) / 2.0 : numArray[numArray.length / 2];
        return median;
    }

    public static double meanf(ArrayList<Float> array, double initialtoIgnorePercentage) {
        return JamArr.mean(array, initialtoIgnorePercentage);
    }

    public static double stdf(ArrayList<Float> array) {
        return JamArr.stdf(array, 0.0);
    }

    public static double stdf(ArrayList<Float> array, double initialToIgnorePercentage) {
        return JamArr.std(array, initialToIgnorePercentage);
    }

    public static double mean(double[] data) {
        double sum = 0.0;
        for (double a : data) {
            sum += a;
        }
        return sum / (double)data.length;
    }

    public static double mean(int[] data) {
        double sum = 0.0;
        for (int a : data) {
            sum += (double)a;
        }
        return sum / (double)data.length;
    }

    public static double mean(double[][] data) {
        return JamArr.mean(data, -1)[0];
    }

    public static double[] mean(double[][] data, int dim) {
        double[] mean;
        if (dim == 0) {
            mean = new double[data.length];
            for (int i = 0; i < data.length; ++i) {
                mean[i] = JamArr.mean(data[i]);
            }
        } else if (dim == 1) {
            mean = new double[data[0].length];
            for (int i = 0; i < data[0].length; ++i) {
                double[] meanTemp = new double[data.length];
                for (int j = 0; j < data.length; ++j) {
                    meanTemp[i] = data[j][i];
                }
                mean[i] = JamArr.mean(meanTemp);
            }
        } else {
            double sum = 0.0;
            int count = 0;
            for (int i = 0; i < data.length; ++i) {
                for (int j = 0; j < data[i].length; ++j) {
                    sum += data[i][j];
                    ++count;
                }
            }
            mean = new double[]{sum / (double)count};
        }
        return mean;
    }

    public static double median(double[][] data) {
        return JamArr.median(data, -1)[0];
    }

    public static double[] median(double[][] data, int dim) {
        double[] median;
        if (dim == 0) {
            median = new double[data.length];
            for (int i = 0; i < data.length; ++i) {
                median[i] = JamArr.median(data[i]);
            }
        } else if (dim == 1) {
            median = new double[data[0].length];
            for (int i = 0; i < data[0].length; ++i) {
                double[] medianTemp = new double[data.length];
                for (int j = 0; j < data.length; ++j) {
                    medianTemp[j] = data[j][i];
                }
                median[i] = JamArr.median(medianTemp);
            }
        } else {
            int count = 0;
            for (int i = 0; i < data.length; ++i) {
                count += data[i].length;
            }
            double[] flatarray = new double[count];
            count = 0;
            for (int i = 0; i < data.length; ++i) {
                for (int j = 0; j < data[i].length; ++j) {
                    flatarray[count] = data[i][j];
                    ++count;
                }
            }
            median = new double[]{JamArr.median(flatarray)};
        }
        return median;
    }

    public static double std(double[][] data) {
        return JamArr.std(data, -1)[0];
    }

    public static double[] std(double[][] data, int dim) {
        double[] std;
        if (dim == 0) {
            std = new double[data.length];
            for (int i = 0; i < data.length; ++i) {
                std[i] = JamArr.std(data[i]);
            }
        } else if (dim == 1) {
            std = new double[data[0].length];
            for (int i = 0; i < data[0].length; ++i) {
                double[] stdTemp = new double[data.length];
                for (int j = 0; j < data.length; ++j) {
                    stdTemp[i] = data[j][i];
                }
                std[i] = JamArr.std(stdTemp);
            }
        } else {
            int count = 0;
            for (int i = 0; i < data.length; ++i) {
                count += data[i].length;
            }
            double[] flatarray = new double[count];
            count = 0;
            for (int i = 0; i < data.length; ++i) {
                for (int j = 0; j < data[i].length; ++j) {
                    flatarray[count] = data[i][j];
                    ++count;
                }
            }
            std = new double[]{JamArr.std(flatarray)};
        }
        return std;
    }

    public static double varience(double[] data) {
        double mean = JamArr.mean(data);
        double temp = 0.0;
        for (double a : data) {
            temp += (mean - a) * (mean - a);
        }
        return temp / (double)data.length;
    }

    public static double std(double[] data) {
        return Math.sqrt(JamArr.varience(data));
    }

    public static double[][] transposeMatrix(double[][] m) {
        double[][] temp = new double[m[0].length][m.length];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length; ++j) {
                temp[j][i] = m[i][j];
            }
        }
        return temp;
    }

    public static List<Integer> sort(ArrayList<? extends Number> array) {
        TreeMap<Number, ArrayList<Integer>> map = new TreeMap<Number, ArrayList<Integer>>();
        for (int i = 0; i < array.size(); ++i) {
            ArrayList<Integer> ind = (ArrayList<Integer>)map.get(array.get(i));
            if (ind == null) {
                ind = new ArrayList<Integer>();
                map.put(array.get(i), ind);
            }
            ind.add(i);
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (List arr : map.values()) {
            indices.addAll(arr);
        }
        return indices;
    }

    public static <T> ArrayList<T> sort(ArrayList<? extends Number> arrayOrdered, ArrayList<T> arrayToSort) {
        List<Integer> indexSort = JamArr.sort(arrayOrdered);
        ArrayList<T> arraySorted = new ArrayList<T>(indexSort.size());
        for (int i = 0; i < indexSort.size(); ++i) {
            arraySorted.add(arrayToSort.get(indexSort.get(i)));
        }
        return arraySorted;
    }

    public static double minmaxdiff(double[] arr) {
        double max = Double.NEGATIVE_INFINITY;
        double min = Double.POSITIVE_INFINITY;
        for (double cur : arr) {
            max = Math.max(max, cur);
            min = Math.min(min, cur);
        }
        return max - min;
    }

    public static double[] minmax(double[] arr) {
        double max = Double.NEGATIVE_INFINITY;
        double min = Double.POSITIVE_INFINITY;
        for (double cur : arr) {
            if (Double.isNaN(cur)) continue;
            max = Math.max(max, cur);
            min = Math.min(min, cur);
        }
        return new double[]{min, max};
    }

    public static double[] minmax(double[][] arr) {
        double max = Double.NEGATIVE_INFINITY;
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                if (Double.isNaN(arr[i][j])) continue;
                max = Math.max(max, arr[i][j]);
                min = Math.min(min, arr[i][j]);
            }
        }
        return new double[]{min, max};
    }

    public static int[] minmax(int[][] arr) {
        int max = Integer.MAX_VALUE;
        int min = Integer.MIN_VALUE;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                max = Math.max(max, arr[i][j]);
                min = Math.min(min, arr[i][j]);
            }
        }
        return new int[]{min, max};
    }

    public static double max(double[] arr) {
        double max = Double.NEGATIVE_INFINITY;
        for (double cur : arr) {
            if (Double.isNaN(cur)) continue;
            max = Math.max(max, cur);
        }
        return max;
    }

    public static int max(int[][] arr) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                max = Math.max(max, arr[i][j]);
            }
        }
        return max;
    }

    public static double max(double[][] arr) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                if (Double.isNaN(arr[i][j])) continue;
                max = Math.max(max, arr[i][j]);
            }
        }
        return max;
    }

    public static double max(float[] arr) {
        double max = Double.NEGATIVE_INFINITY;
        float[] fArray = arr;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            double cur = fArray[i];
            max = Math.max(max, cur);
        }
        return max;
    }

    public static int max(int[] arr) {
        int max = Integer.MIN_VALUE;
        for (int cur : arr) {
            max = Math.max(max, cur);
        }
        return max;
    }

    public static double min(double[] arr) {
        double min = Double.POSITIVE_INFINITY;
        for (double cur : arr) {
            if (Double.isNaN(cur)) continue;
            min = Math.min(min, cur);
        }
        return min;
    }

    public static int min(int[] arr) {
        int min = Integer.MAX_VALUE;
        for (int cur : arr) {
            min = Math.min(min, cur);
        }
        return min;
    }

    public static int min(int[][] arr) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                min = Math.min(min, arr[i][j]);
            }
        }
        return min;
    }

    public static double min(double[][] arr) {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                if (Double.isNaN(arr[i][j])) continue;
                min = Math.min(min, arr[i][j]);
            }
        }
        return min;
    }

    public static double[] normalise(double[] arr) {
        return JamArr.normalise(arr, 1.0);
    }

    public static double[] normalise(double[] arr, double scaleFactor) {
        if (arr != null) {
            int n = arr.length;
            double sum = 0.0;
            for (int i = 0; i < n; ++i) {
                sum += arr[i] * arr[i];
            }
            sum = Math.pow(sum, 0.5);
            double[] normArr = new double[arr.length];
            for (int i = 0; i < normArr.length; ++i) {
                normArr[i] = scaleFactor * arr[i] / sum;
            }
            return normArr;
        }
        return null;
    }

    public static double[] pow(double[] array, double exp) {
        double[] arrExp = new double[array.length];
        for (int i = 0; i < arrExp.length; ++i) {
            arrExp[i] = Math.pow(array[i], exp);
        }
        return arrExp;
    }

    public static int sum(int[] array) {
        int sum = 0;
        for (int val : array) {
            sum += val;
        }
        return sum;
    }

    public static double sum(double[] array) {
        double sum = 0.0;
        for (double val : array) {
            sum += val;
        }
        return sum;
    }

    public static double sum(double[][] array2) {
        double sum = 0.0;
        for (int i = 0; i < array2.length; ++i) {
            double[] array;
            for (double val : array = array2[i]) {
                sum += val;
            }
        }
        return sum;
    }

    public static void printArray(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            System.out.println(i + ": " + array[i]);
        }
    }

    public static void printArray(int[] array) {
        for (int i = 0; i < array.length; ++i) {
            System.out.println(i + ": " + array[i]);
        }
    }

    public static void printArray(double[][] array) {
        for (int j = 0; j < array.length; ++j) {
            System.out.println("");
            for (int i = 0; i < array[j].length; ++i) {
                System.out.print(array[j][i] + " : ");
            }
        }
        System.out.println("");
    }

    public static void printArray(int[][] array) {
        for (int j = 0; j < array.length; ++j) {
            System.out.println("");
            for (int i = 0; i < array[j].length; ++i) {
                System.out.print(array[j][i] + " : ");
            }
        }
        System.out.println("");
    }

    public static double[] list2ArrayD(List<Double> listArray) {
        double[] array = new double[listArray.size()];
        for (int i = 0; i < listArray.size(); ++i) {
            array[i] = listArray.get(i);
        }
        return array;
    }

    public static boolean unique(double[] array) {
        boolean duplicates = false;
        for (int j = 0; j < array.length; ++j) {
            for (int k = j + 1; k < array.length; ++k) {
                if (k == j || array[k] != array[j]) continue;
                duplicates = true;
            }
        }
        return duplicates;
    }

    public static double[] divide(double[] array, double divisor) {
        double[] arrayD = new double[array.length];
        for (int j = 0; j < array.length; ++j) {
            arrayD[j] = array[j] / divisor;
        }
        return arrayD;
    }

    private static double[] divide(double b, double[] array) {
        double[] arrayD = new double[array.length];
        for (int j = 0; j < array.length; ++j) {
            arrayD[j] = b / array[j];
        }
        return arrayD;
    }

    public static double[][] divide(double[][] array, double divisor) {
        double[][] arrayD = new double[array.length][];
        for (int j = 0; j < array.length; ++j) {
            arrayD[j] = JamArr.divide(array[j], divisor);
        }
        return arrayD;
    }

    public static double[][] divide(double divisor, double[][] array) {
        double[][] arrayD = new double[array.length][];
        for (int j = 0; j < array.length; ++j) {
            arrayD[j] = JamArr.divide(divisor, array[j]);
        }
        return arrayD;
    }

    public static String array2String(float[] array, int decimalPlaces, String delimiter) {
        Object outArray = "";
        for (int i = 0; i < array.length; ++i) {
            outArray = (String)outArray + String.format("%.2" + decimalPlaces + "f", Float.valueOf(array[i]));
            if (i >= array.length - 1) continue;
            outArray = (String)outArray + ",";
        }
        return outArray;
    }

    public static String array2String(double[] array, int decimalPlaces, String delimiter) {
        Object outArray = "";
        for (int i = 0; i < array.length; ++i) {
            outArray = (String)outArray + String.format("%.2" + decimalPlaces + "f", array[i]);
            if (i >= array.length - 1) continue;
            outArray = (String)outArray + ",";
        }
        return outArray;
    }

    public static String array2String(Number[] array, int decimalPlaces, String delimiter) {
        Object outArray = "";
        for (int i = 0; i < array.length; ++i) {
            outArray = (String)outArray + String.format("%.2" + decimalPlaces + "f", array[i]);
            if (i >= array.length - 1) continue;
            outArray = (String)outArray + ",";
        }
        return outArray;
    }

    public static double[] string2array(String array, String delimitter) {
        String[] strArray = array.split(delimitter);
        double[] outArray = new double[strArray.length];
        for (int i = 0; i < strArray.length; ++i) {
            outArray[i] = Double.valueOf(strArray[i]);
        }
        return outArray;
    }

    public static String array2String(double[] array, int decimalPlaces) {
        return JamArr.array2String(array, decimalPlaces, ",");
    }

    public static double[] string2array(String array) {
        return JamArr.string2array(array, ",");
    }

    public static boolean isATrue(boolean[] boolArray) {
        for (int i = 0; i < boolArray.length; ++i) {
            if (!boolArray[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] arr, int num) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != num) continue;
            return true;
        }
        return false;
    }

    public static double[] subtract(double[] a, double[] b) {
        double[] output = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            output[i] = a[i] - b[i];
        }
        return output;
    }

    public static double[] subtract(double[] a, double b) {
        double[] output = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            output[i] = a[i] - b;
        }
        return output;
    }

    public static double[][] subtract(double[][] img, double b) {
        double[][] output = new double[img.length][];
        for (int i = 0; i < img.length; ++i) {
            double[] temp = new double[img[i].length];
            for (int j = 0; j < img[i].length; ++j) {
                temp[j] = img[i][j] - b;
            }
            output[i] = temp;
        }
        return output;
    }

    public static double[] add(double[] a, double[] b) {
        double[] output = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            output[i] = a[i] + b[i];
        }
        return output;
    }

    public static double[] add(double[] a, double b) {
        double[] output = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            output[i] = a[i] + b;
        }
        return output;
    }

    public static double[][] add(double[][] img, double b) {
        double[][] output = new double[img.length][];
        for (int i = 0; i < img.length; ++i) {
            double[] temp = new double[img[i].length];
            for (int j = 0; j < img[i].length; ++j) {
                temp[j] = img[i][j] + b;
            }
            output[i] = temp;
        }
        return output;
    }

    public static double[] product(double[] a, double[] b) {
        double[] output = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            output[i] = a[i] * b[i];
        }
        return output;
    }

    public static double[] product(double[] a, double b) {
        double[] output = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            output[i] = a[i] * b;
        }
        return output;
    }

    public static int[] subtract(int[] a, int[] b) {
        int[] output = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            output[i] = a[i] - b[i];
        }
        return output;
    }

    public static int[] subtract(int[] a, int b) {
        int[] output = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            output[i] = a[i] - b;
        }
        return output;
    }

    public static int[] add(int[] a, int[] b) {
        int[] output = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            output[i] = a[i] + b[i];
        }
        return output;
    }

    public static int[] add(int[] a, int b) {
        int[] output = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            output[i] = a[i] + b;
        }
        return output;
    }

    public static int[] product(int[] a, int[] b) {
        int[] output = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            output[i] = a[i] * b[i];
        }
        return output;
    }

    public static int[] product(int[] a, int b) {
        int[] output = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            output[i] = a[i] * b;
        }
        return output;
    }

    public static double[] product(int[] a, double b) {
        double[] output = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            output[i] = (double)a[i] * b;
        }
        return output;
    }

    public static double[][] product(double[][] img, double b) {
        double[][] output = new double[img.length][];
        for (int i = 0; i < img.length; ++i) {
            double[] temp = new double[img[i].length];
            for (int j = 0; j < img[i].length; ++j) {
                temp[j] = img[i][j] * b;
            }
            output[i] = temp;
        }
        return output;
    }

    public static double[][] exp(double[][] img) {
        double[][] output = new double[img.length][];
        for (int i = 0; i < img.length; ++i) {
            double[] temp = new double[img[i].length];
            for (int j = 0; j < img[i].length; ++j) {
                temp[j] = Math.exp(img[i][j]);
            }
            output[i] = temp;
        }
        return output;
    }

    public static double[][] product(double[][] img1, double[][] img2) {
        double[][] output = new double[img1.length][];
        for (int i = 0; i < img1.length; ++i) {
            double[] temp = new double[img1[i].length];
            for (int j = 0; j < img1[i].length; ++j) {
                temp[j] = img1[i][j] * img2[i][j];
            }
            output[i] = temp;
        }
        return output;
    }

    public static int[] rearrange(int[] arr, int[] pos) {
        int[] aux = new int[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            aux[pos[i]] = arr[i];
        }
        return aux;
    }

    public static double[] rearrange(double[] arr, int[] pos) {
        double[] aux = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            aux[pos[i]] = arr[i];
        }
        return aux;
    }

    public static float[] rearrange(float[] arr, int[] pos) {
        float[] aux = new float[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            aux[pos[i]] = arr[i];
        }
        return aux;
    }

    public static String[] rearrange(String[] arr, int[] pos) {
        String[] aux = new String[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            aux[pos[i]] = arr[i];
        }
        return aux;
    }
}

