/*
 * Decompiled with CFR 0.152.
 */
package org.jamdev.jpamutils.spectrogram;

import java.io.Serializable;

public class Complex
implements Cloneable,
Serializable {
    public static final long serialVersionUID = 1L;
    public double real = 0.0;
    public double imag = 0.0;
    private static long conCalls = 0L;

    public Complex() {
        ++conCalls;
    }

    public Complex(double real, double imag) {
        this.real = real;
        this.imag = imag;
        ++conCalls;
    }

    public Complex(Complex a) {
        this.real = a.real;
        this.imag = a.imag;
        ++conCalls;
    }

    public Complex clone() {
        try {
            return (Complex)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public double ang() {
        if (this.real == 0.0 && this.imag == 0.0) {
            return 0.0;
        }
        return Math.atan2(this.imag, this.real);
    }

    public double magsq() {
        return this.real * this.real + this.imag * this.imag;
    }

    @Deprecated
    public double norm() {
        return this.real * this.real + this.imag * this.imag;
    }

    public double mag() {
        return Math.sqrt(this.magsq());
    }

    public Complex sqrt() {
        double newmag = Math.sqrt(this.mag());
        double newang = this.ang() / 2.0;
        return new Complex(newmag * Math.cos(newang), newmag * Math.sin(newang));
    }

    public Complex pow(double f) {
        double newmag = Math.pow(this.mag(), f);
        double newang = this.ang() * f;
        return new Complex(newmag * Math.cos(newang), newmag * Math.sin(newang));
    }

    public Complex exp() {
        return new Complex(Math.exp(this.real) * Math.cos(this.imag), Math.exp(this.real) * Math.sin(this.imag));
    }

    public Complex plus(Complex b) {
        return new Complex(this.real + b.real, this.imag + b.imag);
    }

    public void assign(Complex b) {
        this.real = b.real;
        this.imag = b.imag;
    }

    public void assign(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public Complex plus(double b) {
        return new Complex(this.real + b, this.imag);
    }

    public Complex minus(Complex b) {
        return new Complex(this.real - b.real, this.imag - b.imag);
    }

    public Complex minus(double b) {
        return new Complex(this.real - b, this.imag);
    }

    public Complex times(double b) {
        return new Complex(this.real * b, this.imag * b);
    }

    public Complex times(Complex b) {
        return new Complex(this.real * b.real - this.imag * b.imag, this.real * b.imag + this.imag * b.real);
    }

    public void internalTimes(double b) {
        this.real *= b;
        this.imag *= b;
    }

    public void internalTimes(Complex b) {
        double newReal = this.real * b.real - this.imag * b.imag;
        double newImag = this.real * b.imag + this.imag * b.real;
        this.real = newReal;
        this.imag = newImag;
    }

    public Complex conj() {
        return new Complex(this.real, -this.imag);
    }

    public static void conj(Complex x) {
        x.imag = -x.imag;
    }

    public boolean isNaN() {
        return Double.isNaN(this.imag) || Double.isNaN(this.real);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.imag) || Double.isInfinite(this.real);
    }

    public static Complex[] createComplexArray(double[] doubleArray) {
        Complex[] c = Complex.allocateComplexArray(doubleArray.length);
        for (int i = 0; i < doubleArray.length; ++i) {
            c[i].real = doubleArray[i];
        }
        return c;
    }

    public static Complex[] allocateComplexArray(int n) {
        Complex[] newArray = new Complex[n];
        for (int i = 0; i < n; ++i) {
            newArray[i] = new Complex();
        }
        return newArray;
    }

    public static Complex[][] allocateComplexArray(int n, int m) {
        Complex[][] newArray = new Complex[n][m];
        newArray = new Complex[n][];
        for (int i = 0; i < n; ++i) {
            newArray[i] = Complex.allocateComplexArray(m);
        }
        return newArray;
    }

    public static void zeroComplexArray(Complex[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i].assign(0.0, 0.0);
        }
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(String format) {
        return String.format("[" + format + ", i" + format + "]", this.real, this.imag);
    }

    public String toString(int decimalPlaces) {
        return String.format("[%." + decimalPlaces + "f, i%." + decimalPlaces + "f]", this.real, this.imag);
    }

    public static long getConstructorCalls() {
        return conCalls;
    }
}

