/*
 * Decompiled with CFR 0.152.
 */
package org.jamdev.jpamutils.spectrogram;

import java.io.Serializable;
import java.util.Arrays;
import org.jamdev.jpamutils.spectrogram.Complex;

public class ComplexArrayD
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected double[] data;

    public ComplexArrayD(int n) {
        this.data = new double[n * 2];
    }

    public ComplexArrayD(double[] complexData) {
        this.data = complexData;
    }

    public ComplexArrayD(double[] realData, double[] imagData) {
        this.data = new double[realData.length * 2];
        int i = 0;
        int j = 0;
        while (i < realData.length) {
            this.data[j] = realData[i];
            this.data[j + 1] = imagData[i];
            ++i;
            j += 2;
        }
    }

    public ComplexArrayD(org.apache.commons.math3.complex.Complex[] complexArr) {
        this.data = new double[complexArr.length * 2];
        int i = 0;
        int j = 0;
        while (i < complexArr.length) {
            this.data[j] = complexArr[i].getReal();
            this.data[j + 1] = complexArr[i].getImaginary();
            ++i;
            j += 2;
        }
    }

    public ComplexArrayD copyOf(int newLength) {
        return new ComplexArrayD(Arrays.copyOf(this.data, newLength * 2));
    }

    public void set(int i, double re, double im) {
        i <<= 1;
        this.data[i++] = re;
        this.data[i] = im;
    }

    public void set(int i, Complex complex) {
        i <<= 1;
        this.data[i++] = complex.real;
        this.data[i] = complex.imag;
    }

    public Complex get(int i) {
        return new Complex(this.data[i * 2], this.data[i * 2 + 1]);
    }

    public int length() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length / 2;
    }

    public ComplexArrayD clone() {
        try {
            ComplexArrayD newOne = (ComplexArrayD)super.clone();
            newOne.data = (double[])this.data.clone();
            return newOne;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public double[] ang() {
        if (this.data == null) {
            return null;
        }
        double[] angles = new double[this.data.length / 2];
        int re = 0;
        int im = 1;
        int o = 0;
        while (re < this.data.length) {
            if (this.data[re] == 0.0 && this.data[im] == 0.0) {
                angles[o] = 0.0;
            } else {
                angles[0] = Math.atan2(this.data[im], this.data[re]);
            }
            re += 2;
            im += 2;
            ++o;
        }
        return angles;
    }

    public double ang(int i) {
        double re = this.data[i * 2];
        double im = this.data[i * 2 + 1];
        if (re == 0.0 && im == 0.0) {
            return 0.0;
        }
        return Math.atan2(im, re);
    }

    public double[] magsq() {
        if (this.data == null) {
            return null;
        }
        double[] out = new double[this.data.length / 2];
        int re = 0;
        int im = 1;
        int o = 0;
        while (re < this.data.length) {
            out[o] = this.data[re] * this.data[re] + this.data[im] * this.data[im];
            re += 2;
            im += 2;
            ++o;
        }
        return out;
    }

    public double magsq(int i) {
        i <<= 1;
        double re = this.data[i++];
        double im = this.data[i];
        return re * re + im * im;
    }

    public double[] mag() {
        double[] out = this.magsq();
        for (int i = 0; i < out.length; ++i) {
            out[i] = Math.sqrt(out[i]);
        }
        return out;
    }

    public double mag(int i) {
        return Math.sqrt(this.magsq(i));
    }

    public ComplexArrayD sqrt() {
        if (this.data == null) {
            return null;
        }
        ComplexArrayD s = new ComplexArrayD(this.length());
        for (int o = 0; o < this.data.length / 2; ++o) {
            double newmag = Math.sqrt(this.mag(o));
            double newang = this.ang(o) / 2.0;
            s.set(o, newmag * Math.cos(newang), newmag * Math.sin(newang));
        }
        return s;
    }

    public Complex sqrt(int i) {
        double newmag = Math.sqrt(this.mag(i));
        double newang = this.ang(i) / 2.0;
        return new Complex(newmag * Math.cos(newang), newmag * Math.sin(newang));
    }

    public ComplexArrayD pow(double f) {
        if (this.data == null) {
            return null;
        }
        ComplexArrayD s = new ComplexArrayD(this.length());
        for (int o = 0; o < this.data.length / 2; ++o) {
            double newmag = Math.pow(this.mag(o), f);
            double newang = this.ang(o) * f;
            s.set(o, newmag * Math.cos(newang), newmag * Math.sin(newang));
        }
        return s;
    }

    public Complex pow(int i, double f) {
        double newmag = Math.pow(this.mag(i), f);
        double newang = this.ang(i) * f;
        return new Complex(newmag * Math.cos(newang), newmag * Math.sin(newang));
    }

    public ComplexArrayD plus(ComplexArrayD c) {
        if (this.data == null) {
            return null;
        }
        ComplexArrayD s = this.clone();
        for (int i = 0; i < c.data.length; ++i) {
            int n = i;
            s.data[n] = s.data[n] + c.data[i];
        }
        return s;
    }

    public ComplexArrayD minus(ComplexArrayD c) {
        if (this.data == null) {
            return null;
        }
        ComplexArrayD s = this.clone();
        for (int i = 0; i < c.data.length; ++i) {
            int n = i;
            s.data[n] = s.data[n] - c.data[i];
        }
        return s;
    }

    public ComplexArrayD times(double f) {
        if (this.data == null) {
            return null;
        }
        double[] tData = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            tData[i] = this.data[i] * f;
        }
        return new ComplexArrayD(tData);
    }

    public Complex times(int i, double f) {
        return new Complex(this.getReal(i) * f, this.getImag(i) * f);
    }

    public ComplexArrayD conj() {
        if (this.data == null) {
            return null;
        }
        double[] tData = (double[])this.data.clone();
        for (int i = 1; i < tData.length; i += 2) {
            tData[i] = -tData[i];
        }
        return new ComplexArrayD(tData);
    }

    public ComplexArrayD conjTimes(ComplexArrayD s) {
        if (this.data == null) {
            return null;
        }
        double[] sData = s.data;
        double[] tData = new double[this.data.length];
        int re = 0;
        int im = 1;
        while (re < this.data.length) {
            tData[re] = this.data[re] * sData[re] + this.data[im] * sData[im];
            tData[im] = -this.data[re] * sData[im] + this.data[im] * sData[re];
            re += 2;
            im += 2;
        }
        return new ComplexArrayD(tData);
    }

    public ComplexArrayD conjTimes(ComplexArrayD s, int[] binRange) {
        if (this.data == null) {
            return null;
        }
        double[] sData = s.data;
        double[] tData = new double[this.data.length];
        int re = binRange[0] * 2;
        int im = binRange[0] * 2 + 1;
        while (re < binRange[1] * 2) {
            tData[re] = this.data[re] * sData[re] + this.data[im] * sData[im];
            tData[im] = -this.data[re] * sData[im] + this.data[im] * sData[re];
            re += 2;
            im += 2;
        }
        return new ComplexArrayD(tData);
    }

    public Complex dotProduct(ComplexArrayD s) {
        if (this.data == null) {
            return null;
        }
        double[] sData = s.data;
        double realVal = 0.0;
        double imVal = 0.0;
        int re = 0;
        int im = 1;
        while (re < this.data.length) {
            realVal += this.data[re] * sData[re] + this.data[im] * sData[im];
            imVal += -this.data[re] * sData[im] + this.data[im] * sData[re];
            re += 2;
            im += 2;
        }
        return new Complex(realVal, imVal);
    }

    public ComplexArrayD[] calcCSDM() {
        ComplexArrayD[] csdm = new ComplexArrayD[this.length()];
        for (int row = 0; row < this.length(); ++row) {
            ComplexArrayD prelim = new ComplexArrayD(this.length());
            for (int col = 0; col < this.length(); ++col) {
                prelim.data[col * 2] = this.data[row * 2] * this.data[col * 2] + this.data[row * 2 + 1] * this.data[col * 2 + 1];
                prelim.data[col * 2 + 1] = -this.data[row * 2] * this.data[col * 2 + 1] + this.data[row * 2 + 1] * this.data[col * 2];
            }
            csdm[row] = prelim;
        }
        return csdm;
    }

    public double[] getReal() {
        double[] r = new double[this.data.length / 2];
        int i = 0;
        for (int j = 0; j < this.data.length; j += 2) {
            r[i] = this.data[j];
            ++i;
        }
        return r;
    }

    public double getReal(int i) {
        return this.data[i << 1];
    }

    public void setReal(int i, double re) {
        this.data[i << 1] = re;
    }

    public double getImag(int i) {
        return this.data[(i <<= 1) + 1];
    }

    public double[] getImag() {
        double[] r = new double[this.data.length / 2];
        int i = 0;
        for (int j = 1; j < this.data.length; j += 2) {
            r[i] = this.data[j];
            ++i;
        }
        return r;
    }

    public void setImag(int i, double im) {
        this.data[i * 2 + 1] = im;
    }

    public double[] getData() {
        return this.data;
    }

    public void setData(double[] data) {
        this.data = data;
    }

    public boolean isNaN(int i) {
        return Double.isNaN(this.data[i << 1]) || Double.isNaN(this.data[(i << 1) + 1]);
    }

    public void internalTimes(double d) {
        int i = 0;
        while (i < this.data.length) {
            int n = i++;
            this.data[n] = this.data[n] * d;
        }
    }

    public ComplexArrayD times(Complex b) {
        double[] newData = (double[])this.data.clone();
        for (int i = 0; i < newData.length; i += 2) {
            Complex a = new Complex(newData[i], newData[i + 1]);
            a = a.times(b);
            newData[i] = a.real;
            newData[i + 1] = a.imag;
        }
        return new ComplexArrayD(newData);
    }

    public void internalTimes(int i, double d) {
        i <<= 1;
        int n = i++;
        this.data[n] = this.data[n] * d;
        int n2 = i;
        this.data[n2] = this.data[n2] * d;
    }

    public void setZero() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0.0;
        }
    }

    public ComplexArrayD fillConjugateHalf() {
        double[] fData = Arrays.copyOf(this.data, this.data.length * 2);
        int re1 = 0;
        int im1 = 1;
        int re2 = fData.length - 2;
        int im2 = fData.length - 1;
        while (re1 < this.data.length) {
            fData[re2] = this.data[re1];
            fData[im2] = -this.data[im1];
            re1 += 2;
            im1 += 2;
            re2 -= 2;
            im2 -= 2;
        }
        return new ComplexArrayD(fData);
    }

    public static ComplexArrayD realToComplex(double[] realArray) {
        if (realArray == null) {
            return null;
        }
        int n = realArray.length;
        double[] cData = new double[n * 2];
        int i = 0;
        int j = 0;
        while (i < n) {
            cData[j] = realArray[i];
            ++i;
            j += 2;
        }
        return new ComplexArrayD(cData);
    }

    public double sumSquared() {
        double s = 0.0;
        int ir = 0;
        int im = 1;
        while (ir < this.data.length) {
            double rV = this.data[ir];
            double iV = this.data[im];
            s += rV * rV + iV * iV;
            ir += 2;
            im += 2;
        }
        return s;
    }

    public static double sumSquared(double[] complexData) {
        double s = 0.0;
        int ir = 0;
        int im = 1;
        while (ir < complexData.length) {
            double rV = complexData[ir];
            double iV = complexData[im];
            s += rV * rV + iV * iV;
            ir += 2;
            im += 2;
        }
        return s;
    }
}

