/*
 * Decompiled with CFR 0.152.
 */
package org.jamdev.jpamutils.spectrogram;

import java.io.Serializable;
import java.util.Arrays;
import org.jamdev.jpamutils.spectrogram.Complex;

public class ComplexArrayF
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected float[] data;

    public ComplexArrayF(int n) {
        this.data = new float[n * 2];
    }

    public ComplexArrayF(float[] complexData) {
        this.data = complexData;
    }

    public ComplexArrayF(float[] realData, float[] imagData) {
        this.data = new float[realData.length * 2];
        int i = 0;
        int j = 0;
        while (i < realData.length) {
            this.data[j] = realData[i];
            this.data[j + 1] = imagData[i];
            ++i;
            j += 2;
        }
    }

    public ComplexArrayF(org.apache.commons.math3.complex.Complex[] complexArr) {
        this.data = new float[complexArr.length * 2];
        int i = 0;
        int j = 0;
        while (i < complexArr.length) {
            this.data[j] = (float)complexArr[i].getReal();
            this.data[j + 1] = (float)complexArr[i].getImaginary();
            ++i;
            j += 2;
        }
    }

    public ComplexArrayF copyOf(int newLength) {
        return new ComplexArrayF(Arrays.copyOf(this.data, newLength * 2));
    }

    public void set(int i, float re, float im) {
        i <<= 1;
        this.data[i++] = re;
        this.data[i] = im;
    }

    public void set(int i, double re, double im) {
        i <<= 1;
        this.data[i++] = (float)re;
        this.data[i] = (float)im;
    }

    public void set(int i, Complex complex) {
        i <<= 1;
        this.data[i++] = (float)complex.real;
        this.data[i] = (float)complex.imag;
    }

    public Complex get(int i) {
        return new Complex(this.data[i * 2], this.data[i * 2 + 1]);
    }

    public int length() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length / 2;
    }

    public ComplexArrayF clone() {
        try {
            ComplexArrayF newOne = (ComplexArrayF)super.clone();
            newOne.data = (float[])this.data.clone();
            return newOne;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public float[] ang() {
        if (this.data == null) {
            return null;
        }
        float[] angles = new float[this.data.length / 2];
        int re = 0;
        int im = 1;
        int o = 0;
        while (re < this.data.length) {
            if (this.data[re] == 0.0f && this.data[im] == 0.0f) {
                angles[o] = 0.0f;
            } else {
                angles[0] = (float)Math.atan2(this.data[im], this.data[re]);
            }
            re += 2;
            im += 2;
            ++o;
        }
        return angles;
    }

    public float ang(int i) {
        float re = this.data[i * 2];
        float im = this.data[i * 2 + 1];
        if (re == 0.0f && im == 0.0f) {
            return 0.0f;
        }
        return (float)Math.atan2(im, re);
    }

    public float[] magsq() {
        if (this.data == null) {
            return null;
        }
        float[] out = new float[this.data.length / 2];
        int re = 0;
        int im = 1;
        int o = 0;
        while (re < this.data.length) {
            out[o] = this.data[re] * this.data[re] + this.data[im] * this.data[im];
            re += 2;
            im += 2;
            ++o;
        }
        return out;
    }

    public float magsq(int i) {
        i <<= 1;
        float re = this.data[i++];
        float im = this.data[i];
        return re * re + im * im;
    }

    public float[] mag() {
        float[] out = this.magsq();
        for (int i = 0; i < out.length; ++i) {
            out[i] = (float)Math.sqrt(out[i]);
        }
        return out;
    }

    public float mag(int i) {
        return (float)Math.sqrt(this.magsq(i));
    }

    public ComplexArrayF sqrt() {
        if (this.data == null) {
            return null;
        }
        ComplexArrayF s = new ComplexArrayF(this.length());
        for (int o = 0; o < this.data.length / 2; ++o) {
            float newmag = (float)Math.sqrt(this.mag(o));
            float newang = (float)((double)this.ang(o) / 2.0);
            s.set(o, (float)((double)newmag * Math.cos(newang)), (float)((double)newmag * Math.sin(newang)));
        }
        return s;
    }

    public Complex sqrt(int i) {
        float newmag = (float)Math.sqrt(this.mag(i));
        float newang = (float)((double)this.ang(i) / 2.0);
        return new Complex((double)newmag * Math.cos(newang), (double)newmag * Math.sin(newang));
    }

    public ComplexArrayF pow(float f) {
        if (this.data == null) {
            return null;
        }
        ComplexArrayF s = new ComplexArrayF(this.length());
        for (int o = 0; o < this.data.length / 2; ++o) {
            float newmag = (float)Math.pow(this.mag(o), f);
            float newang = this.ang(o) * f;
            s.set(o, (float)((double)newmag * Math.cos(newang)), (float)((double)newmag * Math.sin(newang)));
        }
        return s;
    }

    public Complex pow(int i, float f) {
        float newmag = (float)Math.pow(this.mag(i), f);
        float newang = this.ang(i) * f;
        return new Complex((float)((double)newmag * Math.cos(newang)), (float)((double)newmag * Math.sin(newang)));
    }

    public ComplexArrayF plus(ComplexArrayF c) {
        if (this.data == null) {
            return null;
        }
        ComplexArrayF s = this.clone();
        for (int i = 0; i < c.data.length; ++i) {
            int n = i;
            s.data[n] = s.data[n] + c.data[i];
        }
        return s;
    }

    public ComplexArrayF minus(ComplexArrayF c) {
        if (this.data == null) {
            return null;
        }
        ComplexArrayF s = this.clone();
        for (int i = 0; i < c.data.length; ++i) {
            int n = i;
            s.data[n] = s.data[n] - c.data[i];
        }
        return s;
    }

    public ComplexArrayF times(float f) {
        if (this.data == null) {
            return null;
        }
        float[] tData = new float[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            tData[i] = this.data[i] * f;
        }
        return new ComplexArrayF(tData);
    }

    public Complex times(int i, float f) {
        return new Complex(this.getReal(i) * f, this.getImag(i) * f);
    }

    public ComplexArrayF conj() {
        if (this.data == null) {
            return null;
        }
        float[] tData = (float[])this.data.clone();
        for (int i = 1; i < tData.length; i += 2) {
            tData[i] = -tData[i];
        }
        return new ComplexArrayF(tData);
    }

    public ComplexArrayF conjTimes(ComplexArrayF s) {
        if (this.data == null) {
            return null;
        }
        float[] sData = s.data;
        float[] tData = new float[this.data.length];
        int re = 0;
        int im = 1;
        while (re < this.data.length) {
            tData[re] = this.data[re] * sData[re] + this.data[im] * sData[im];
            tData[im] = -this.data[re] * sData[im] + this.data[im] * sData[re];
            re += 2;
            im += 2;
        }
        return new ComplexArrayF(tData);
    }

    public ComplexArrayF conjTimes(ComplexArrayF s, int[] binRange) {
        if (this.data == null) {
            return null;
        }
        float[] sData = s.data;
        float[] tData = new float[this.data.length];
        int re = binRange[0] * 2;
        int im = binRange[0] * 2 + 1;
        while (re < binRange[1] * 2) {
            tData[re] = this.data[re] * sData[re] + this.data[im] * sData[im];
            tData[im] = -this.data[re] * sData[im] + this.data[im] * sData[re];
            re += 2;
            im += 2;
        }
        return new ComplexArrayF(tData);
    }

    public Complex dotProduct(ComplexArrayF s) {
        if (this.data == null) {
            return null;
        }
        float[] sData = s.data;
        float realVal = 0.0f;
        float imVal = 0.0f;
        int re = 0;
        int im = 1;
        while (re < this.data.length) {
            realVal += this.data[re] * sData[re] + this.data[im] * sData[im];
            imVal += -this.data[re] * sData[im] + this.data[im] * sData[re];
            re += 2;
            im += 2;
        }
        return new Complex(realVal, imVal);
    }

    public ComplexArrayF[] calcCSDM() {
        ComplexArrayF[] csdm = new ComplexArrayF[this.length()];
        for (int row = 0; row < this.length(); ++row) {
            ComplexArrayF prelim = new ComplexArrayF(this.length());
            for (int col = 0; col < this.length(); ++col) {
                prelim.data[col * 2] = this.data[row * 2] * this.data[col * 2] + this.data[row * 2 + 1] * this.data[col * 2 + 1];
                prelim.data[col * 2 + 1] = -this.data[row * 2] * this.data[col * 2 + 1] + this.data[row * 2 + 1] * this.data[col * 2];
            }
            csdm[row] = prelim;
        }
        return csdm;
    }

    public float[] getReal() {
        float[] r = new float[this.data.length / 2];
        int i = 0;
        for (int j = 0; j < this.data.length; j += 2) {
            r[i] = this.data[j];
            ++i;
        }
        return r;
    }

    public float getReal(int i) {
        return this.data[i << 1];
    }

    public void setReal(int i, float re) {
        this.data[i << 1] = re;
    }

    public float getImag(int i) {
        return this.data[(i <<= 1) + 1];
    }

    public float[] getImag() {
        float[] r = new float[this.data.length / 2];
        int i = 0;
        for (int j = 1; j < this.data.length; j += 2) {
            r[i] = this.data[j];
            ++i;
        }
        return r;
    }

    public void setImag(int i, float im) {
        this.data[i * 2 + 1] = im;
    }

    public float[] getData() {
        return this.data;
    }

    public void setData(float[] data) {
        this.data = data;
    }

    public boolean isNaN(int i) {
        return Float.isNaN(this.data[i << 1]) || Float.isNaN(this.data[(i << 1) + 1]);
    }

    public void internalTimes(float d) {
        int i = 0;
        while (i < this.data.length) {
            int n = i++;
            this.data[n] = this.data[n] * d;
        }
    }

    public ComplexArrayF times(Complex b) {
        float[] newData = (float[])this.data.clone();
        for (int i = 0; i < newData.length; i += 2) {
            Complex a = new Complex(newData[i], newData[i + 1]);
            a = a.times(b);
            newData[i] = (float)a.real;
            newData[i + 1] = (float)a.imag;
        }
        return new ComplexArrayF(newData);
    }

    public void internalTimes(int i, float d) {
        i <<= 1;
        int n = i++;
        this.data[n] = this.data[n] * d;
        int n2 = i;
        this.data[n2] = this.data[n2] * d;
    }

    public void internalTimes(int i, double d) {
        i <<= 1;
        int n = i++;
        this.data[n] = (float)((double)this.data[n] * d);
        int n2 = i;
        this.data[n2] = (float)((double)this.data[n2] * d);
    }

    public void setZero() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0.0f;
        }
    }

    public ComplexArrayF fillConjugateHalf() {
        float[] fData = Arrays.copyOf(this.data, this.data.length * 2);
        int re1 = 0;
        int im1 = 1;
        int re2 = fData.length - 2;
        int im2 = fData.length - 1;
        while (re1 < this.data.length) {
            fData[re2] = this.data[re1];
            fData[im2] = -this.data[im1];
            re1 += 2;
            im1 += 2;
            re2 -= 2;
            im2 -= 2;
        }
        return new ComplexArrayF(fData);
    }

    public static ComplexArrayF realToComplex(float[] realArray) {
        if (realArray == null) {
            return null;
        }
        int n = realArray.length;
        float[] cData = new float[n * 2];
        int i = 0;
        int j = 0;
        while (i < n) {
            cData[j] = realArray[i];
            ++i;
            j += 2;
        }
        return new ComplexArrayF(cData);
    }

    public float sumSquared() {
        float s = 0.0f;
        int ir = 0;
        int im = 1;
        while (ir < this.data.length) {
            float rV = this.data[ir];
            float iV = this.data[im];
            s += rV * rV + iV * iV;
            ir += 2;
            im += 2;
        }
        return s;
    }

    public static float sumSquared(float[] complexData) {
        float s = 0.0f;
        int ir = 0;
        int im = 1;
        while (ir < complexData.length) {
            float rV = complexData[ir];
            float iV = complexData[im];
            s += rV * rV + iV * iV;
            ir += 2;
            im += 2;
        }
        return s;
    }
}

