/*
 * Decompiled with CFR 0.152.
 */
package org.jamdev.jpamutils.spectrogram;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import java.util.Arrays;
import org.jamdev.jpamutils.spectrogram.Complex;
import org.jamdev.jpamutils.spectrogram.ComplexArray;

public class FastFFT {
    private DoubleFFT_1D doubleFFT_1D;
    private DoubleFFT_2D doubleFFT_2D;
    private int transformSize = 0;
    private double[] dummyX;

    public synchronized Complex[] rfft(double[] x, Complex[] y, int m) {
        int n = 1 << m;
        this.dummyX = Arrays.copyOf(x, n);
        if (this.doubleFFT_1D == null || this.transformSize != n) {
            this.transformSize = n;
            this.doubleFFT_1D = new DoubleFFT_1D(this.transformSize);
        }
        this.doubleFFT_1D.realForward(this.dummyX);
        return this.packDoubleToComplex(this.dummyX, y);
    }

    public synchronized ComplexArray rfft(double[] x, int n) {
        double[] y = Arrays.copyOf(x, n);
        if (this.doubleFFT_1D == null || this.transformSize != n) {
            this.transformSize = n;
            this.doubleFFT_1D = new DoubleFFT_1D(this.transformSize);
        }
        this.doubleFFT_1D.realForward(y);
        return new ComplexArray(y);
    }

    public synchronized ComplexArray rfftFull(double[] x, int n) {
        double[] y = new double[2 * n];
        System.arraycopy(x, 0, y, 0, x.length);
        if (this.doubleFFT_1D == null || this.transformSize != n) {
            this.transformSize = n;
            this.doubleFFT_1D = new DoubleFFT_1D(n);
        }
        this.doubleFFT_1D.realForwardFull(y);
        return new ComplexArray(y);
    }

    public synchronized void fft(Complex[] x) {
        double[] d = this.packComplexToDouble(x, this.dummyX);
        int n = x.length;
        if (this.doubleFFT_1D == null || this.transformSize != n) {
            this.transformSize = n;
            this.doubleFFT_1D = new DoubleFFT_1D(this.transformSize);
        }
        this.doubleFFT_1D.complexForward(d);
        this.packDoubleToComplex(d, x);
    }

    public synchronized void fft(ComplexArray x) {
        int n = x.length();
        if (this.doubleFFT_1D == null || this.transformSize != n) {
            this.transformSize = n;
            this.doubleFFT_1D = new DoubleFFT_1D(this.transformSize);
        }
        this.doubleFFT_1D.complexForward(x.getData());
    }

    public synchronized void fft(Complex[][] x) {
        int rows = x.length;
        int cols = x[0].length;
        this.doubleFFT_2D = new DoubleFFT_2D(rows, cols);
        double[][] d = this.packComplexToDouble(x);
        this.doubleFFT_2D.complexForward(d);
        x = this.packDoubleToComplex(d, x);
    }

    public synchronized void ifft(Complex[] x, int m) {
        int n = 1 << m;
        Complex[] inData = x;
        double[] d = this.packComplexToDouble(x, this.dummyX);
        if (this.doubleFFT_1D == null || this.transformSize != n) {
            this.transformSize = n;
            this.doubleFFT_1D = new DoubleFFT_1D(this.transformSize);
        }
        this.doubleFFT_1D.complexInverse(d, false);
        this.packDoubleToComplex(d, x);
        if (x != inData) {
            System.out.println("Repacked complex data into new array - ERROR !!!!");
        }
    }

    public synchronized void ifft(ComplexArray x, int n) {
        this.ifft(x, n, false);
    }

    public synchronized void ifft(ComplexArray x, int n, boolean scale) {
        double[] data = x.getData();
        if (data.length != 2 * n) {
            data = Arrays.copyOf(data, 2 * n);
        }
        if (this.doubleFFT_1D == null || this.transformSize != n) {
            this.transformSize = n;
            this.doubleFFT_1D = new DoubleFFT_1D(this.transformSize);
        }
        this.doubleFFT_1D.complexInverse(data, scale);
        x.setData(data);
    }

    public static synchronized int nextBinaryExp(int sourceNumber) {
        int power = 0;
        for (int i = 0; i < 31 && (power = 1 << i) < sourceNumber; ++i) {
        }
        return power;
    }

    public static synchronized int nextBinaryExp(int startPower, int sourceNumber) {
        int power = startPower;
        for (int i = startPower; i < 31 && (power = 1 << i) < sourceNumber; ++i) {
        }
        return power;
    }

    public static synchronized int log2(int num) {
        for (int i = 0; i < 32; ++i) {
            if (1 << i != num) continue;
            return i;
        }
        return -1;
    }

    double[][] packComplexToDouble(Complex[][] c) {
        int nR = c.length;
        int nC = c[0].length;
        double[][] d = new double[nR][nC * 2];
        for (int i = 0; i < nR; ++i) {
            d[i] = this.packComplexToDouble(c[i], d[i]);
        }
        return d;
    }

    Complex[][] packDoubleToComplex(double[][] d, Complex[][] c) {
        int nR = d.length;
        int nC = d[0].length / 2;
        if (c == null || c.length != d.length) {
            c = new Complex[nR][];
        }
        for (int i = 0; i < nR; ++i) {
            c[i] = this.packDoubleToComplex(d[i], c[i]);
        }
        return c;
    }

    private double[] packComplexToDouble(Complex[] c, double[] d) {
        int n = c.length;
        if (d == null || d.length != 2 * n) {
            d = new double[2 * n];
        }
        int iD = 0;
        for (int i = 0; i < n; ++i) {
            d[iD++] = c[i].real;
            d[iD++] = c[i].imag;
        }
        return d;
    }

    private Complex[] packDoubleToComplex(double[] d, Complex[] c) {
        int n = d.length;
        int m = n / 2;
        if ((m *= 2) != n) {
            System.out.println(String.format("Complex packing error - odd number of datas = %d", n));
        }
        if (c == null || c.length != n / 2) {
            c = Complex.allocateComplexArray(n / 2);
        }
        int iC = 0;
        int i = 0;
        try {
            for (i = 0; i < n; i += 2) {
                c[iC].real = d[i];
                c[iC++].imag = d[i + 1];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }
}

