/*
 * Decompiled with CFR 0.152.
 */
package org.jamdev.jpamutils.spectrogram;

import org.jamdev.jpamutils.spectrogram.ComplexArray;

public class GaussianFilter {
    private double[][] kernel;
    private int nCol;
    private int nRow;
    private ChannelProcess[] channelProcesses;

    public GaussianFilter() {
        this.setKernel(new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}});
        this.initialise(1);
    }

    public double[][] generateKernal(double sigma) {
        int y;
        int x;
        int W = 5;
        double[][] kernel = new double[W][W];
        double mean = W / 2;
        double sum = 0.0;
        for (x = 0; x < W; ++x) {
            for (y = 0; y < W; ++y) {
                kernel[x][y] = Math.exp(-0.5 * (Math.pow(((double)x - mean) / sigma, 2.0) + Math.pow(((double)y - mean) / sigma, 2.0))) / (Math.PI * 2 * sigma * sigma);
                sum += kernel[x][y];
            }
        }
        for (x = 0; x < W; ++x) {
            y = 0;
            while (y < W) {
                double[] dArray = kernel[x];
                int n = y++;
                dArray[n] = dArray[n] / sum;
            }
        }
        return kernel;
    }

    public void setKernel(double[][] kernel) {
        this.kernel = kernel;
        this.nCol = kernel.length;
        this.nRow = kernel[0].length;
        this.normaliseKernel();
    }

    private void normaliseKernel() {
        int j;
        int i;
        double kt = 0.0;
        for (i = 0; i < this.kernel.length; ++i) {
            for (j = 0; j < this.kernel[i].length; ++j) {
                kt += this.kernel[i][j];
            }
        }
        for (i = 0; i < this.kernel.length; ++i) {
            j = 0;
            while (j < this.kernel[i].length) {
                double[] dArray = this.kernel[i];
                int n = j++;
                dArray[n] = dArray[n] / kt;
            }
        }
    }

    public ComplexArray[] runFilter(ComplexArray[] complexArray) {
        this.initialise(1);
        for (int i = 0; i < complexArray.length; ++i) {
            this.runNoiseReduction(complexArray[i]);
        }
        return complexArray;
    }

    public String getDescription() {
        return "<html>The spectrogram is smoothed by convolving <p>the image with a Gaussian smoothing kernel e.g.<p> 1 2 1<p> 2 4 2<p> 1 2 1</html>";
    }

    public boolean initialise(int channelMap) {
        this.channelProcesses = new ChannelProcess[4];
        for (int i = 0; i < this.channelProcesses.length; ++i) {
            if ((channelMap & 1 << i) == 0) continue;
            this.channelProcesses[i] = new ChannelProcess();
        }
        return true;
    }

    public boolean runNoiseReduction(ComplexArray fftDataUnit) {
        return this.channelProcesses[0].run(fftDataUnit);
    }

    public boolean runNoiseReduction(ComplexArray fftDataUnit, int sigma) {
        return this.channelProcesses[0].run(fftDataUnit);
    }

    class ChannelProcess {
        private double[][] localStore;
        private ComplexArray[] localComplex;

        public ChannelProcess() {
            this.localStore = new double[GaussianFilter.this.nCol][];
            this.localComplex = new ComplexArray[GaussianFilter.this.nCol];
        }

        boolean run(ComplexArray complexArray) {
            int lastCol = GaussianFilter.this.nCol - 1;
            double[] dummyStore = this.localStore[0];
            ComplexArray dummyComplex = this.localComplex[0];
            for (int iCol = 0; iCol < lastCol; ++iCol) {
                this.localStore[iCol] = this.localStore[iCol + 1];
                this.localComplex[iCol] = this.localComplex[iCol + 1];
            }
            this.localStore[lastCol] = dummyStore;
            this.localComplex[lastCol] = dummyComplex;
            int space = 1;
            int L = complexArray.length() + 2 * space;
            if (this.localStore[lastCol] == null || this.localStore[lastCol].length != L) {
                this.localStore[lastCol] = new double[L];
            }
            for (int i = 0; i < complexArray.length(); ++i) {
                this.localStore[lastCol][i + space] = complexArray.magsq(i);
            }
            this.localComplex[lastCol] = complexArray.clone();
            if (this.localStore[0] == null) {
                return false;
            }
            for (int i = 0; i < complexArray.length(); ++i) {
                double dumTot = 0.0;
                double cenVal = this.localStore[1][i + space];
                for (int iCol = 0; iCol < GaussianFilter.this.nCol; ++iCol) {
                    for (int iRow = 0; iRow < GaussianFilter.this.nRow; ++iRow) {
                        dumTot += this.localStore[iCol][iRow + i] * GaussianFilter.this.kernel[iCol][iRow];
                    }
                }
                double f = Math.sqrt(dumTot / cenVal);
                complexArray.set(i, this.localComplex[1].getReal(i) * f, this.localComplex[1].getImag(i) * f);
            }
            return true;
        }
    }
}

